/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.spring.web.servlet;

import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.johnson.spring.web.SpringEventType;
import com.atlassian.johnson.spring.web.context.JohnsonContextLoaderListener;
import javax.annotation.Nonnull;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Conventions;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class JohnsonDispatcherServlet
extends DispatcherServlet {
    public static final String PREFIX_BYPASSED = Conventions.getQualifiedAttributeName(JohnsonDispatcherServlet.class, (String)"bypassed");
    private static final Logger LOG = LoggerFactory.getLogger(JohnsonDispatcherServlet.class);
    private String servletContextAttributeName;

    public JohnsonDispatcherServlet() {
    }

    public JohnsonDispatcherServlet(WebApplicationContext webApplicationContext) {
        super(webApplicationContext);
    }

    public void destroy() {
        try {
            super.destroy();
        }
        finally {
            this.getServletContext().removeAttribute(this.getBypassedAttributeName());
        }
    }

    public String getServletContextAttributeName() {
        if (this.servletContextAttributeName == null) {
            return this.getDefaultServletContextAttributeName();
        }
        return this.servletContextAttributeName;
    }

    public void setServletContextAttributeName(String servletContextAttributeName) {
        this.servletContextAttributeName = servletContextAttributeName;
    }

    @Nonnull
    protected Event createEvent(@Nonnull String defaultEventType, @Nonnull String defaultMessage, @Nonnull Throwable t) {
        return SpringEventType.createDefaultEvent(defaultEventType, defaultMessage, t);
    }

    @Nonnull
    protected String getBypassedAttributeName() {
        return PREFIX_BYPASSED + ":" + this.getServletName();
    }

    protected String getDefaultServletContextAttributeName() {
        return super.getServletContextAttributeName();
    }

    protected WebApplicationContext initWebApplicationContext() {
        ServletConfig servletConfig = this.getServletConfig();
        ServletContext servletContext = this.getServletContext();
        JohnsonEventContainer container = Johnson.getEventContainer((ServletContext)servletContext);
        String eventType = SpringEventType.getServletEventType(servletConfig);
        Object attribute = servletContext.getAttribute(JohnsonContextLoaderListener.ATTR_BYPASSED);
        if (Boolean.TRUE == attribute) {
            LOG.error("Bypassing SpringMVC dispatcher [{}] initialisation; Spring initialisation was bypassed", (Object)this.getServletName());
            servletContext.setAttribute(this.getBypassedAttributeName(), (Object)Boolean.TRUE);
            if (SpringEventType.addEventOnBypass(servletConfig)) {
                String message = "SpringMVC dispatcher [" + this.getServletName() + "] will not be started because the Spring WebApplicationContext was not started";
                container.addEvent(new Event(EventType.get((String)eventType), message, EventLevel.get((String)"fatal")));
            }
            return null;
        }
        if (attribute instanceof Event) {
            Event event = (Event)attribute;
            LOG.error("Bypassing SpringMVC dispatcher [{}] initialisation; Spring initialisation failed: {}", (Object)this.getServletName(), (Object)event.getDesc());
            servletContext.setAttribute(this.getBypassedAttributeName(), (Object)Boolean.TRUE);
            if (SpringEventType.addEventOnBypass(servletConfig)) {
                String message = "SpringMVC dispatcher [" + this.getServletName() + "] will not be started because the Spring WebApplicationContext failed to start";
                container.addEvent(new Event(EventType.get((String)eventType), message, event.getLevel()));
            }
            return null;
        }
        WebApplicationContext context = null;
        try {
            LOG.debug("Attempting to initialise the Spring ApplicationContext");
            context = super.initWebApplicationContext();
        }
        catch (Throwable t) {
            String message = "SpringMVC dispatcher [" + this.getServletName() + "] could not be started";
            LOG.error(message, t);
            Event event = SpringEventType.translateThrowable(this.getServletConfig(), t);
            if (event == null && (event = this.createEvent(eventType, message, t)) == null) {
                event = SpringEventType.createDefaultEvent(eventType, message, t);
            }
            servletContext.setAttribute(this.getBypassedAttributeName(), (Object)event);
            container.addEvent(event);
        }
        return context;
    }
}

