/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.spring.web.context;

import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.johnson.spring.web.SpringEventType;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Conventions;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class JohnsonContextLoaderListener
extends ContextLoaderListener {
    public static final String BYPASSED_ATTRIBUTE = Conventions.getQualifiedAttributeName(JohnsonContextLoaderListener.class, (String)"bypassed");
    private static final Logger LOG = LoggerFactory.getLogger(JohnsonContextLoaderListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent event) {
        try {
            super.contextDestroyed(event);
        }
        finally {
            event.getServletContext().removeAttribute(BYPASSED_ATTRIBUTE);
        }
    }

    public WebApplicationContext initWebApplicationContext(ServletContext servletContext) {
        String eventType = SpringEventType.getContextEventType(servletContext);
        JohnsonEventContainer container = Johnson.getEventContainer((ServletContext)servletContext);
        if (container.hasEvents()) {
            LOG.debug("Searching Johnson for previous {} errors", (Object)"fatal");
            for (Event event : container.getEvents()) {
                EventLevel level = event.getLevel();
                if (!"fatal".equals(level.getLevel())) continue;
                LOG.error("Bypassing Spring ApplicationContext initialisation; a previous {} error was found: {}", (Object)level.getLevel(), (Object)event.getDesc());
                servletContext.setAttribute(BYPASSED_ATTRIBUTE, (Object)Boolean.TRUE);
                if (SpringEventType.addEventOnBypass(servletContext)) {
                    String message = "The Spring WebApplicationContext will not be started due to a previous " + level.getLevel() + " error";
                    container.addEvent(new Event(EventType.get((String)eventType), message, level));
                }
                return null;
            }
        }
        WebApplicationContext context = null;
        try {
            LOG.debug("Attempting to initialise the Spring ApplicationContext");
            context = super.initWebApplicationContext(servletContext);
        }
        catch (Throwable t) {
            String message = "The Spring WebApplicationContext could not be started";
            LOG.error(message, t);
            servletContext.removeAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            Event event = this.createEvent(eventType, message, t);
            if (event == null) {
                event = this.createDefaultEvent(eventType, message, t);
            }
            servletContext.setAttribute(BYPASSED_ATTRIBUTE, (Object)event);
            container.addEvent(event);
        }
        return context;
    }

    protected Event createEvent(String defaultEventType, String defaultMessage, Throwable t) {
        return this.createDefaultEvent(defaultEventType, defaultMessage, t);
    }

    private Event createDefaultEvent(String eventType, String message, Throwable t) {
        return new Event(EventType.get((String)eventType), message, Event.toString((Throwable)t), EventLevel.get((String)"fatal"));
    }
}

