/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.spring.web;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.springframework.util.StringUtils;

public class SpringEventType {
    public static final String ADD_EVENT_ON_BYPASS_PARAM = "johnson.spring.addEventOnBypass";
    public static final String EVENT_TYPE_PARAM = "johnson.spring.eventType";
    public static final String SPRING_CONTEXT_EVENT_TYPE = "spring";
    public static final String SPRING_SERVLET_EVENT_TYPE = "spring-mvc";

    private SpringEventType() {
    }

    public static boolean addEventOnBypass(ServletContext context) {
        return "true".equals(context.getInitParameter(ADD_EVENT_ON_BYPASS_PARAM));
    }

    public static boolean addEventOnBypass(ServletConfig config) {
        String value = config.getInitParameter(ADD_EVENT_ON_BYPASS_PARAM);
        if (value == null) {
            return SpringEventType.addEventOnBypass(config.getServletContext());
        }
        return "true".equals(value);
    }

    public static String getContextEventType(ServletContext context) {
        String value = context.getInitParameter(EVENT_TYPE_PARAM);
        if (!StringUtils.hasText((String)value)) {
            value = SPRING_CONTEXT_EVENT_TYPE;
        }
        return value;
    }

    public static String getServletEventType(ServletConfig config) {
        String value = config.getInitParameter(EVENT_TYPE_PARAM);
        if (!StringUtils.hasText((String)value)) {
            value = SPRING_SERVLET_EVENT_TYPE;
        }
        return value;
    }
}

