/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.filters;

import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.filters.AbstractJohnsonFilter;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Johnson503Filter
extends AbstractJohnsonFilter {
    private static final Logger log = LoggerFactory.getLogger(Johnson503Filter.class);

    @Override
    protected void handleError(JohnsonEventContainer appEventContainer, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        log.info("The application is unavailable, or there are errors.  Returing a temporarily unavailable status.");
        servletResponse.setStatus(503);
        if (this.hasOnlyWarnings(appEventContainer)) {
            servletResponse.setHeader("Retry-After", "30");
        }
        servletResponse.getWriter().flush();
    }

    @Override
    protected void handleNotSetup(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        log.info("The application is not setup.  Returing a temporarily unavailable status.");
        servletResponse.setStatus(503);
        servletResponse.getWriter().flush();
    }

    private boolean hasOnlyWarnings(JohnsonEventContainer eventContainer) {
        if (eventContainer != null && eventContainer.hasEvents()) {
            Collection<Event> events = eventContainer.getEvents();
            return this.allEventsAreWarnings(events);
        }
        return false;
    }

    private boolean allEventsAreWarnings(Collection events) {
        for (Object eventObject : events) {
            if (eventObject instanceof Event) {
                if (!this.hasNonWarningLevel((Event)eventObject)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean hasNonWarningLevel(Event event) {
        return !"warning".equals(event.getLevel().getLevel());
    }
}

