package com.atlassian.johnson.event;

import com.atlassian.johnson.Johnson;
import org.apache.commons.lang.ObjectUtils;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EventLevel {

    public static final String ERROR = "error";
    public static final String FATAL = "fatal";
    public static final String WARNING = "warning";

    private final String description;
    private final String level;

    public EventLevel(String level, String description) {
        this.description = description;
        this.level = level;
    }

    @Nullable
    public static EventLevel get(@Nonnull String level) {
        return Johnson.getConfig().getEventLevel(level);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventLevel)) {
            return false;
        }

        EventLevel e = (EventLevel) o;
        return ObjectUtils.equals(getDescription(), e.getDescription()) &&
                ObjectUtils.equals(getLevel(), e.getLevel());
    }

    public String getDescription() {
        return description;
    }

    public String getLevel() {
        return level;
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + ObjectUtils.hashCode(getLevel());
        result = 31 * result + ObjectUtils.hashCode(getDescription());
        return result;
    }

    public String toString() {
        return "(EventLevel: " + level + ")";
    }
}
