/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson;

import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.config.ConfigurationJohnsonException;
import com.atlassian.johnson.config.DefaultJohnsonConfig;
import com.atlassian.johnson.config.JohnsonConfig;
import com.atlassian.johnson.config.XmlJohnsonConfig;
import com.atlassian.johnson.event.ApplicationEventCheck;
import com.atlassian.johnson.setup.ContainerFactory;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Johnson {
    public static final String CONFIG_ATTRIBUTE = Johnson.class.getName() + ":Config";
    public static final String CONFIG_LOCATION_PARAM = "johnsonConfigLocation";
    public static final String EVENT_CONTAINER_ATTRIBUTE = Johnson.class.getName() + ":EventContainer";
    private static final Logger LOG = LoggerFactory.getLogger(Johnson.class);
    private static JohnsonConfig config;
    private static JohnsonEventContainer eventContainer;

    private Johnson() {
    }

    public static JohnsonConfig getConfig() {
        if (config == null) {
            throw new IllegalStateException("Johnson.getConfig() was called before initialisation");
        }
        return config;
    }

    public static JohnsonConfig getConfig(ServletContext context) {
        Object attribute = context.getAttribute(CONFIG_ATTRIBUTE);
        if (attribute != null) {
            return (JohnsonConfig)attribute;
        }
        return config;
    }

    public static JohnsonEventContainer getEventContainer(ServletContext context) {
        Object attribute = context.getAttribute(EVENT_CONTAINER_ATTRIBUTE);
        if (attribute != null) {
            return (JohnsonEventContainer)attribute;
        }
        return eventContainer;
    }

    public static void initialize(ServletContext context) {
        String location = StringUtils.defaultIfEmpty((String)context.getInitParameter(CONFIG_LOCATION_PARAM), (String)"johnson-config.xml");
        Johnson.initialize(location);
        context.setAttribute(CONFIG_ATTRIBUTE, (Object)config);
        context.setAttribute(EVENT_CONTAINER_ATTRIBUTE, (Object)eventContainer);
        List<ApplicationEventCheck> checks = config.getApplicationEventChecks();
        for (ApplicationEventCheck check : checks) {
            check.check(eventContainer, context);
        }
    }

    public static void initialize(String location) {
        location = StringUtils.defaultIfEmpty((String)location, (String)"johnson-config.xml");
        LOG.debug("Initialising Johnson with configuration from [{}]", (Object)location);
        try {
            config = XmlJohnsonConfig.fromFile(location);
        }
        catch (ConfigurationJohnsonException e) {
            LOG.warn("Failed to load configuration from [" + location + "]", (Throwable)e);
            config = DefaultJohnsonConfig.getInstance();
        }
        ContainerFactory containerFactory = config.getContainerFactory();
        eventContainer = containerFactory.create();
    }

    public static void terminate() {
        config = null;
        eventContainer = null;
    }

    public static void terminate(ServletContext context) {
        Johnson.terminate();
        context.removeAttribute(CONFIG_ATTRIBUTE);
        context.removeAttribute(EVENT_CONTAINER_ATTRIBUTE);
    }
}

