package com.atlassian.johnson.event;

import com.atlassian.johnson.Johnson;
import org.apache.commons.lang.ObjectUtils;

public class EventType
{
    private final String description;
    private final String type;

    public EventType(String type, String description)
    {
        this.description = description;
        this.type = type;
    }

    public static EventType get(String type)
    {
        return Johnson.getConfig().getEventType(type);
    }

    public boolean equals(Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (!(o instanceof EventType))
        {
            return false;
        }

        EventType e = (EventType) o;
        return ObjectUtils.equals(getDescription(), e.getDescription()) &&
                ObjectUtils.equals(getType(), e.getType());
    }

    public String getDescription()
    {
        return description;
    }

    public String getType()
    {
        return type;
    }

    public int hashCode()
    {
        int result = 29;
        result = 31 * result + ObjectUtils.hashCode(getType());
        result = 31 * result + ObjectUtils.hashCode(getDescription());
        return result;
    }

    public String toString()
    {
        return "(EventType: " + type + ")";
    }
}
