package com.atlassian.johnson.event;

import java.util.EventObject;

/**
 * An {@code EventObject} indicating the provided {@link Event} should be added to the Johnson event container.
 * 
 * @since 2.0
 */
public class AddEvent extends EventObject
{
    private final Event event;

    /**
     * Constructs a new {@code AddEvent}, setting its source and the Johnson {@link Event} to be added.
     * 
     * @param o     the event source
     * @param event the event to add
     */
    public AddEvent(Object o, Event event)
    {
        super(o);

        this.event = event;
    }

    /**
     * Retrieves the Johnson {@link Event} to add to the container.
     *
     * @return  the event to add
     */
    public Event getEvent()
    {
        return event;
    }
}
