package com.atlassian.johnson.setup;

/**
 * A default, empty implementation of {@link SetupConfig} which always indicates the application is setup.
 *
 * @since 2.0
 */
public class DefaultSetupConfig implements SetupConfig
{
    /**
     * Always {@code true}.
     *
     * @return {@code true}
     */
    @Override
    public boolean isSetup()
    {
        return true;
    }

    /**
     * Always {@code false}.
     *
     * @param uri the URI of a web page
     * @return {@code false}
     */
    @Override
    public boolean isSetupPage(String uri)
    {
        return false;
    }
}
