package com.atlassian.johnson.event;

import com.atlassian.event.api.EventListener;
import com.atlassian.johnson.Johnson;

import javax.servlet.ServletContext;

/**
 * A simple listener which may be used with the Atlassian Events framework to listen for {@link AddEvent add} and
 * {@link RemoveEvent remove} events on the bus, allowing simplified interaction with Johnson.
 *
 * @since 2.0
 */
public class JohnsonEventListener
{
    private final ServletContext servletContext;

    public JohnsonEventListener(ServletContext servletContext)
    {
        this.servletContext = servletContext;
    }

    /**
     * Adds the Johnson {@link Event} wrapped by the provided {@link AddEvent}  to the container.
     * 
     * @param e the add event
     */
    @EventListener
    public void onAdd(AddEvent e)
    {
        Johnson.getEventContainer(servletContext).addEvent(e.getEvent());
    }

    /**
     * Attempts to remove the Johnson {@link Event} wrapped by the provided {@link RemoveEvent} from the container.
     *
     * @param e the remove event
     */
    @EventListener
    public void onRemove(RemoveEvent e)
    {
        Johnson.getEventContainer(servletContext).removeEvent(e.getEvent());
    }
}
