package com.atlassian.johnson.context;

import com.atlassian.johnson.Johnson;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/**
 * Initialises and terminates {@link Johnson} with the servlet container.
 * <p/>
 * In web environments, this is the preferred mechanism for managing Johnson's lifecycle, allowing it to be initialised
 * and terminated in a thread-safe context. This listener should be registered before any others except, if applicable,
 * those that setup logging.
 * <p/>
 * To use this listener, add the following to web.xml:
 * <pre>
 * <code>&lt;listener&gt;
 *     &lt;listener-class&gt;com.atlassian.johnson.context.JohnsonContextListener&lt;/listener-class&gt;
 * &lt;/listener&gt;
 * </code>
 * </pre>
 *
 * @since 2.0
 */
public class JohnsonContextListener implements ServletContextListener
{
    /**
     * Terminates {@link Johnson}.
     * 
     * @param event the context event
     * @see Johnson#terminate(javax.servlet.ServletContext)
     */
    public void contextDestroyed(ServletContextEvent event)
    {
        Johnson.terminate(event.getServletContext());
    }

    /**
     * Initialises {@link Johnson}.
     *
     * @param event the context event
     * @see Johnson#initialize(javax.servlet.ServletContext)
     */
    public void contextInitialized(ServletContextEvent event)
    {
        Johnson.initialize(event.getServletContext());
    }
}
