package com.atlassian.johnson.config;

import com.atlassian.johnson.event.*;
import com.atlassian.johnson.setup.ContainerFactory;
import com.atlassian.johnson.setup.SetupConfig;

import java.util.List;
import java.util.Map;

/**
 * @since 2.0
 */
public interface JohnsonConfig
{
    List<ApplicationEventCheck> getApplicationEventChecks();

    ContainerFactory getContainerFactory();

    String getErrorPath();

    EventCheck getEventCheck(int id);

    List<EventCheck> getEventChecks();

    EventLevel getEventLevel(String level);

    EventType getEventType(String type);

    List<String> getIgnorePaths();

    Map<String, String> getParams();

    List<RequestEventCheck> getRequestEventChecks();

    SetupConfig getSetupConfig();

    String getSetupPath();

    boolean isIgnoredPath(String uri);
}
