/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin.workflows;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.jira.testkit.plugin.workflows.WorkflowSchemeDataFactory;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="project/{projectKey}/workflowscheme")
public class WorkflowSchemeProjectBackdoor {
    private final WorkflowSchemeManager workflowSchemeManager;
    private final WorkflowSchemeDataFactory dataFactory;
    private final ProjectManager projectManager;

    public WorkflowSchemeProjectBackdoor(WorkflowSchemeManager workflowSchemeManager, WorkflowSchemeDataFactory dataFactory, ProjectManager projectManager) {
        this.workflowSchemeManager = workflowSchemeManager;
        this.dataFactory = dataFactory;
        this.projectManager = projectManager;
    }

    @GET
    public Response get(@PathParam(value="projectKey") String projectKey) {
        Project project = this.getProject(projectKey);
        if (project == null) {
            return WorkflowSchemeProjectBackdoor.fourOhFour();
        }
        AssignableWorkflowScheme workflowSchemeObj = this.workflowSchemeManager.getWorkflowSchemeObj(project);
        return this.ok(workflowSchemeObj);
    }

    protected final Response ok(AssignableWorkflowScheme workflowSchemeObj) {
        return Response.ok((Object)this.dataFactory.toData((WorkflowScheme)workflowSchemeObj)).cacheControl(CacheControl.never()).build();
    }

    protected final Project getProject(String projectKey) {
        return this.projectManager.getProjectObjByKey(projectKey);
    }

    private static Response fourOhFour() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
    }
}

