/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin.workflows;

import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="workflow")
public class WorkflowResourceBackdoor {
    private final WorkflowManager workflowManager;

    public WorkflowResourceBackdoor(WorkflowManager workflowManager) {
        this.workflowManager = workflowManager;
    }

    @GET
    public Response getWorkflows() {
        Collection workflows = this.workflowManager.getWorkflows();
        ArrayList str = Lists.newArrayListWithCapacity((int)workflows.size());
        for (JiraWorkflow workflow : workflows) {
            str.add(workflow.getName());
        }
        return Response.ok((Object)str).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="cloneWorkflow")
    public Response cloneWorkflow(@QueryParam(value="sourceName") String sourceName, @QueryParam(value="resultName") String resultName) {
        JiraWorkflow sourceWorkflow = this.workflowManager.getWorkflow(sourceName);
        JiraWorkflow newWorkflow = this.workflowManager.copyWorkflow("admin", resultName, "", sourceWorkflow);
        this.workflowManager.createWorkflow("admin", newWorkflow);
        return Response.ok().build();
    }
}

