/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.user.UserQueryHistoryManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="userhistory")
public class UserHistoryBackdoor {
    private final UserIssueHistoryManager userIssueHistoryManager;
    private final UserManager userManager;
    private final IssueManager issueManager;
    private final UserQueryHistoryManager userQueryHistoryManager;

    public UserHistoryBackdoor(UserIssueHistoryManager userIssueHistoryManager, UserManager userManager, IssueManager issueManager, UserQueryHistoryManager userQueryHistoryManager) {
        this.userIssueHistoryManager = userIssueHistoryManager;
        this.userManager = userManager;
        this.issueManager = issueManager;
        this.userQueryHistoryManager = userQueryHistoryManager;
    }

    @GET
    @AnonymousAllowed
    @Path(value="issue/add")
    public Response addIssue(@QueryParam(value="user") String userName, @QueryParam(value="key") String issueKey) {
        ApplicationUser user = this.userManager.getUserByName(userName);
        MutableIssue issue = this.issueManager.getIssueByKeyIgnoreCase(issueKey);
        this.userIssueHistoryManager.addIssueToHistory(user, (Issue)issue);
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="jqlquery/add")
    public Response addJQLQuery(@QueryParam(value="user") String userName, @QueryParam(value="query") String query) {
        ApplicationUser user = this.userManager.getUserByName(userName);
        this.userQueryHistoryManager.addQueryToHistory(user, query);
        return Response.ok(null).build();
    }
}

