/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousAllowed
@Path(value="systemproperty")
public class SystemPropertyBackdoor {
    private static final Logger log = LoggerFactory.getLogger(SystemPropertyBackdoor.class);

    @GET
    @Path(value="{name}")
    public String get(@PathParam(value="name") String propertyName) {
        this.validateNotBlank(propertyName);
        return System.getProperty(propertyName);
    }

    @POST
    @Path(value="{name}")
    @XsrfProtectionExcluded
    public String set(@PathParam(value="name") String propertyName, @QueryParam(value="value") String propertyValue) {
        this.validateNotBlank(propertyName);
        if (propertyValue != null) {
            log.info("Setting system property '{}' to: {}", (Object)propertyName, (Object)propertyValue);
            System.setProperty(propertyName, propertyValue);
            JiraSystemProperties.resetReferences();
        } else {
            log.warn("cannot set null property: '" + propertyName + "=" + propertyValue + "'");
        }
        return this.get(propertyName);
    }

    @DELETE
    @Path(value="{name}")
    public void unset(@PathParam(value="name") String propertyName) {
        this.validateNotBlank(propertyName);
        log.info("Unsetting system property '{}'", (Object)propertyName);
        System.getProperties().remove(propertyName);
        JiraSystemProperties.resetReferences();
    }

    private void validateNotBlank(String propertyName) {
        if (StringUtils.isBlank((String)propertyName)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Property name must not be blank").build());
        }
    }
}

