/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.testkit.beans.Priority;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="priority")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class PriorityBackdoorResource {
    private final PriorityManager priorityManager;

    public PriorityBackdoorResource(PriorityManager priorityManager) {
        this.priorityManager = priorityManager;
    }

    @GET
    public Response getAllPriorities() {
        ArrayList priorityBeans = Lists.newArrayList();
        for (com.atlassian.jira.issue.priority.Priority priority : this.priorityManager.getPriorities()) {
            priorityBeans.add(this.create(priority));
        }
        return Response.ok((Object)priorityBeans).cacheControl(CacheControl.never()).build();
    }

    @POST
    public Response createPriority(Priority bean) {
        com.atlassian.jira.issue.priority.Priority priority = this.priorityManager.createPriority(bean.getName(), bean.getDescription(), bean.getIconUrl(), bean.getColor());
        return Response.ok((Object)this.create(priority)).cacheControl(CacheControl.never()).build();
    }

    @PUT
    public Response updatePriority(Priority bean) {
        com.atlassian.jira.issue.priority.Priority priority = this.priorityManager.getPriority(bean.getId());
        this.priorityManager.editPriority(priority, bean.getName(), bean.getDescription(), bean.getIconUrl(), bean.getColor());
        return Response.ok((Object)this.create(priority)).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{id}")
    public Response deletePriority(@PathParam(value="id") long id) {
        com.atlassian.jira.issue.priority.Priority defaultPriority = this.priorityManager.getDefaultPriority();
        if (defaultPriority == null) {
            defaultPriority = (com.atlassian.jira.issue.priority.Priority)this.priorityManager.getPriorities().get(0);
        }
        this.priorityManager.removePriority(String.valueOf(id), defaultPriority.getId());
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{id}/up")
    public Response moveUp(@PathParam(value="id") long id) {
        this.priorityManager.movePriorityUp(String.valueOf(id));
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{id}/down")
    public Response moveDown(@PathParam(value="id") long id) {
        this.priorityManager.movePriorityDown(String.valueOf(id));
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{id}/default")
    public Response setDefault(@PathParam(value="id") long id) {
        this.priorityManager.setDefaultPriority(String.valueOf(id));
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    private Priority create(com.atlassian.jira.issue.priority.Priority priority) {
        return new Priority(StringUtils.trimToNull((String)priority.getId()), StringUtils.trimToNull((String)priority.getDescription()), StringUtils.trimToNull((String)priority.getName()), priority.getSequence(), StringUtils.trimToNull((String)priority.getStatusColor()), StringUtils.trimToNull((String)priority.getIconUrl()));
    }
}

