/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.sql.Timestamp;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.ofbiz.core.entity.GenericValue;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="issues")
public class IssuesBackdoorExt {
    private final IssueManager issueManager;
    private final IssueIndexingService issueIndexingService;

    public IssuesBackdoorExt(IssueManager issueManager, IssueIndexingService issueIndexingService) {
        this.issueManager = issueManager;
        this.issueIndexingService = issueIndexingService;
    }

    @PUT
    @Path(value="touch")
    public void touch(@QueryParam(value="key") String key) throws Exception {
        this.changeUpdatedDate(key, System.currentTimeMillis());
    }

    @PUT
    @Path(value="changeUpdated")
    public void changeUpdatedDate(@QueryParam(value="key") String key, @QueryParam(value="date") long millis) throws Exception {
        this.changeDate(key, "updated", millis);
    }

    @PUT
    @Path(value="changeCreated")
    public void changeCratedDate(@QueryParam(value="key") String key, @QueryParam(value="date") long millis) throws Exception {
        this.changeDate(key, "created", millis);
    }

    private void changeDate(String key, String fieldName, long millis) throws Exception {
        GenericValue issue = this.issueManager.getIssue(key);
        issue.set(fieldName, (Object)new Timestamp(millis));
        issue.store();
        this.issueIndexingService.reIndex((Issue)this.issueManager.getIssueObject(key));
    }
}

