/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeDestroyer;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Iterables;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="issueLinking")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueLinkingBackdoorResource {
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueLinkTypeDestroyer issueLinkTypeDestroyer;
    private final UserUtil userUtil;
    private final ApplicationProperties applicationProperties;

    public IssueLinkingBackdoorResource(IssueLinkTypeManager issueLinkTypeManager, IssueLinkTypeDestroyer issueLinkTypeDestroyer, UserUtil userUtil, ApplicationProperties applicationProperties) {
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueLinkTypeDestroyer = issueLinkTypeDestroyer;
        this.userUtil = userUtil;
        this.applicationProperties = applicationProperties;
    }

    @GET
    public Response get() {
        return Response.ok((Object)this.applicationProperties.getOption("jira.option.issuelinking")).cacheControl(CacheControl.never()).build();
    }

    @POST
    public Response set(Boolean enabled) {
        if (enabled.booleanValue() != this.applicationProperties.getOption("jira.option.issuelinking")) {
            this.applicationProperties.setOption("jira.option.issuelinking", enabled.booleanValue());
        }
        return Response.ok((Object)this.applicationProperties.getOption("jira.option.issuelinking")).cacheControl(CacheControl.never()).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="create")
    public Response addLink(@QueryParam(value="name") String name, @QueryParam(value="outward") String outward, @QueryParam(value="inward") String inward, @QueryParam(value="style") String style) {
        this.issueLinkTypeManager.createIssueLinkType(name, outward, inward, style);
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="delete")
    public Response deleteLink(@QueryParam(value="name") String name) {
        ApplicationUser sysadmin = (ApplicationUser)Iterables.get((Iterable)this.userUtil.getJiraSystemAdministrators(), (int)0);
        for (IssueLinkType issueLink : this.issueLinkTypeManager.getIssueLinkTypesByName(name)) {
            this.issueLinkTypeDestroyer.removeIssueLinkType(issueLink.getId(), null, sysadmin);
        }
        return Response.ok(null).build();
    }
}

