/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.gadgets.dashboard.Layout;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.portal.PortletConfigurationManager;
import com.atlassian.jira.sharing.SharePermissionImpl;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.jira.testkit.plugin.util.Errors;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/dashboard")
public class DashboardBackdoor {
    private final PortalPageService portalPageService;
    private final FavouritesService favouritesService;
    private final PortletConfigurationManager portletConfigurationManager;
    private final UserUtil userUtil;

    public DashboardBackdoor(PortalPageService portalPageService, UserUtil userUtil, FavouritesService favouritesService, PortletConfigurationManager portletConfigurationManager) {
        this.portalPageService = portalPageService;
        this.userUtil = userUtil;
        this.favouritesService = favouritesService;
        this.portletConfigurationManager = portletConfigurationManager;
    }

    @GET
    @Path(value="my")
    public Response getMyDasbhoards(@QueryParam(value="username") String username) {
        if ((username = StringUtils.trimToNull((String)username)) == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).entity((Object)"No user passed.").build();
        }
        ApplicationUser user = this.userUtil.getUserByName(username);
        if (user == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).entity((Object)("User '" + username + "' does not exist.")).build();
        }
        return Response.ok().cacheControl(CacheControl.never()).entity(this.asBeans(user, this.portalPageService.getOwnedPortalPages(user))).build();
    }

    @GET
    @Path(value="emptySystemDashboard")
    public Response emptySystemDashboard() {
        PortalPage systemDashboard = this.portalPageService.getSystemDefaultPortalPage();
        List portlets = this.portletConfigurationManager.getByPortalPage(systemDashboard.getId());
        for (PortletConfiguration pc : portlets) {
            this.portletConfigurationManager.delete(pc);
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="add")
    public Response createNewDashboard(@QueryParam(value="username") String username, @QueryParam(value="name") String name, @QueryParam(value="description") String description, @QueryParam(value="global") boolean global, @QueryParam(value="layout") String layoutString, @QueryParam(value="favorite") boolean favorite) {
        ApplicationUser user = this.userUtil.getUserByName(username);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        JiraServiceContextImpl context = new JiraServiceContextImpl(user, (ErrorCollection)errorCollection);
        PortalPage.Builder builder = PortalPage.name((String)name).owner(user);
        if (description != null) {
            builder.description(description);
        }
        if (layoutString != null) {
            try {
                Layout layout = Layout.valueOf((String)layoutString);
                builder.layout(layout);
            }
            catch (RuntimeException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).entity((Object)("'" + layoutString + "' is not a valid layout name.")).build();
            }
        }
        SharedEntity.SharePermissions permissions = global ? SharedEntity.SharePermissions.GLOBAL : SharedEntity.SharePermissions.PRIVATE;
        builder.permissions(permissions);
        PortalPage portal = this.portalPageService.createPortalPage((JiraServiceContext)context, builder.build());
        if (favorite) {
            this.favouritesService.addFavourite((JiraServiceContext)context, (SharedEntity)portal);
        }
        return Response.ok().cacheControl(CacheControl.never()).entity((Object)new PortalPageBean(portal, this.favouritesService.isFavourite(user, (SharedEntity)portal))).build();
    }

    @GET
    @Path(value="delete")
    public Response deleteDashboard(@QueryParam(value="username") String username, @QueryParam(value="id") Long id) {
        ApplicationUser user = this.userUtil.getUserByName(username);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        JiraServiceContextImpl context = new JiraServiceContextImpl(user, (ErrorCollection)errorCollection);
        this.portalPageService.deletePortalPage((JiraServiceContext)context, id);
        if (errorCollection.hasAnyErrors()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).entity((Object)Errors.of((ErrorCollection)errorCollection)).build();
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="update")
    public Response updateDashboard(@QueryParam(value="username") String username, @QueryParam(value="id") Long id, @QueryParam(value="name") String name, @QueryParam(value="ownername") String ownername, @QueryParam(value="description") String description, @QueryParam(value="shareGroupName") String shareGroupName, @QueryParam(value="favorite") boolean favorite) {
        SharedEntity.SharePermissions permissions;
        ApplicationUser user = this.userUtil.getUserByName(username);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        JiraServiceContextImpl context = new JiraServiceContextImpl(user, (ErrorCollection)errorCollection);
        PortalPage.Builder builder = PortalPage.id((Long)id).owner(this.userUtil.getUserByName(ownername));
        if (description != null) {
            builder.description(description);
        }
        if (name != null) {
            builder.name(name);
        }
        if (shareGroupName != null) {
            permissions = new SharedEntity.SharePermissions(Collections.singleton(new SharePermissionImpl(ShareType.Name.GROUP, shareGroupName, null)));
            builder.permissions(permissions);
        } else {
            permissions = SharedEntity.SharePermissions.PRIVATE;
        }
        builder.permissions(permissions);
        PortalPage portalPage = builder.build();
        this.portalPageService.updatePortalPage((JiraServiceContext)context, portalPage, favorite);
        if (errorCollection.hasAnyErrors()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).entity((Object)Errors.of((ErrorCollection)errorCollection)).build();
        }
        return Response.ok().cacheControl(CacheControl.never()).entity((Object)new PortalPageBean(portalPage, this.favouritesService.isFavourite(user, (SharedEntity)portalPage))).build();
    }

    private Iterable<PortalPageBean> asBeans(final ApplicationUser user, Iterable<? extends PortalPage> portalPages) {
        return Iterables.transform(portalPages, (Function)new Function<PortalPage, PortalPageBean>(){

            public PortalPageBean apply(PortalPage input) {
                return new PortalPageBean(input, DashboardBackdoor.this.favouritesService.isFavourite(user, (SharedEntity)input));
            }
        });
    }

    @JsonAutoDetect
    public static class PortalPageBean {
        private Long id;
        private String name;
        private String owner;
        private String description;
        private Long favouriteCount;
        private boolean favourite;

        public PortalPageBean() {
        }

        public PortalPageBean(PortalPage page, boolean favourite) {
            this.id = page.getId();
            this.name = page.getName();
            this.description = page.getDescription();
            this.owner = page.getOwnerUserName();
            this.favouriteCount = page.getFavouriteCount();
            this.favourite = favourite;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getOwner() {
            return this.owner;
        }

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Long getFavouriteCount() {
            return this.favouriteCount;
        }

        public void setFavouriteCount(Long favouriteCount) {
            this.favouriteCount = favouriteCount;
        }

        public boolean isFavourite() {
            return this.favourite;
        }

        public void setFavourite(boolean favourite) {
            this.favourite = favourite;
        }
    }
}

