/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClasspathResources {
    public static Iterable<String> getResources(String location, Pattern pattern) {
        ImmutableList.Builder allResources = ImmutableList.builder();
        try {
            for (URL singleLocation : ClasspathResources.iterate(location)) {
                if (ClasspathResources.isFile(singleLocation)) {
                    File dir = new File(singleLocation.getFile());
                    if (!dir.isDirectory()) continue;
                    allResources.addAll(ClasspathResources.getResourcesFromDirectory(dir, pattern));
                    continue;
                }
                if (!ClasspathResources.isJar(singleLocation)) continue;
                allResources.addAll(ClasspathResources.getResourcesFromJarFileInLocation(ClasspathResources.getJarFile(singleLocation), location, pattern));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return allResources.build();
    }

    private static ImmutableList<URL> iterate(String location) throws IOException {
        return ImmutableList.copyOf((Iterator)Iterators.forEnumeration(ClasspathResources.class.getClassLoader().getResources(location)));
    }

    private static boolean isFile(URL singleLocation) {
        return "file".equals(singleLocation.getProtocol());
    }

    private static boolean isJar(URL singleLocation) {
        return "jar".equals(singleLocation.getProtocol());
    }

    private static File getJarFile(URL singleLocation) {
        String jarPath = singleLocation.getFile().split("\\!")[0];
        if (jarPath.startsWith("file:")) {
            return new File(jarPath.substring("file:".length()));
        }
        return new File(jarPath);
    }

    private static Collection<String> getResourcesFromJarFileInLocation(File file, String location, Pattern pattern) {
        ArrayList<String> retval = new ArrayList<String>();
        ZipFile zf = null;
        try {
            zf = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                String fileName;
                ZipEntry ze = e.nextElement();
                if (!ClasspathResources.matchesLocation(ze, location) || !pattern.matcher(fileName = ClasspathResources.getFileName(ze)).matches()) continue;
                retval.add(fileName);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ClasspathResources.closeQuietly(zf);
                throw throwable;
            }
        }
        ClasspathResources.closeQuietly(zf);
        return retval;
    }

    private static void closeQuietly(ZipFile zf) {
        if (zf != null) {
            try {
                zf.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean matchesLocation(ZipEntry ze, String location) {
        return ze.getName().startsWith(location);
    }

    private static String getFileName(ZipEntry ze) {
        return ze.getName();
    }

    private static Collection<String> getResourcesFromDirectory(File directory, Pattern pattern) {
        File[] fileList;
        ArrayList<String> retval = new ArrayList<String>();
        for (File file : fileList = directory.listFiles()) {
            if (file.isDirectory()) {
                retval.addAll(ClasspathResources.getResourcesFromDirectory(file, pattern));
                continue;
            }
            try {
                String fileName = file.getCanonicalPath();
                boolean accept = pattern.matcher(fileName).matches();
                if (!accept) continue;
                retval.add(fileName);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        return retval;
    }
}

