/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.testkit.beans.Status;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="status")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class StatusBackdoorResource {
    private final StatusManager statusManager;

    public StatusBackdoorResource(StatusManager statusManager) {
        this.statusManager = statusManager;
    }

    @GET
    public Response getAllStatuses() {
        ArrayList statusBeans = Lists.newArrayList();
        for (com.atlassian.jira.issue.status.Status status : this.statusManager.getStatuses()) {
            statusBeans.add(this.create(status));
        }
        return Response.ok((Object)statusBeans).cacheControl(CacheControl.never()).build();
    }

    @POST
    public Response createStatus(Status bean) {
        com.atlassian.jira.issue.status.Status status = this.statusManager.createStatus(bean.getName(), bean.getDescription(), bean.getIconUrl());
        return Response.ok((Object)this.create(status)).cacheControl(CacheControl.never()).build();
    }

    @PUT
    public Response updateStatus(Status bean) {
        com.atlassian.jira.issue.status.Status status = this.statusManager.getStatus(bean.getId());
        this.statusManager.editStatus(status, bean.getName(), bean.getDescription(), bean.getIconUrl());
        return Response.ok((Object)this.create(status)).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{id}")
    public Response deleteStatus(@PathParam(value="id") long id) {
        this.statusManager.removeStatus(String.valueOf(id));
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    private Status create(com.atlassian.jira.issue.status.Status status) {
        return new Status(StringUtils.trimToNull((String)status.getId()), StringUtils.trimToNull((String)status.getName()), StringUtils.trimToNull((String)status.getDescription()), StringUtils.trimToNull((String)status.getIconUrl()));
    }
}

