/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="services")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ServicesBackdoor {
    private final ServiceManager serviceManager;

    public ServicesBackdoor(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    @GET
    public Response getServices() throws Exception {
        ArrayList services = Lists.newArrayList();
        for (JiraServiceContainer serviceContainer : this.serviceManager.getServices()) {
            services.add(new ServiceBean(serviceContainer));
        }
        return Response.ok((Object)services).build();
    }

    @GET
    @Path(value="/{id}")
    public Response getService(@PathParam(value="id") Long id) throws Exception {
        JiraServiceContainer container = this.serviceManager.getServiceWithId(id);
        return container == null ? Response.status((Response.Status)Response.Status.NOT_FOUND).build() : Response.ok((Object)new ServiceBean(container)).build();
    }

    @POST
    @Path(value="/{id}/run")
    public void runService(@PathParam(value="id") Long id) throws Exception {
        this.serviceManager.runNow(id.longValue());
    }

    public static class ServiceBean {
        public Long id;
        public String name;
        public String serviceClass;
        public boolean usable;
        public Map<String, String> params;

        public ServiceBean() {
        }

        public ServiceBean(JiraServiceContainer serviceContainer) {
            this.id = serviceContainer.getId();
            this.name = serviceContainer.getName();
            this.serviceClass = serviceContainer.getServiceClass();
            this.usable = serviceContainer.isUsable();
            try {
                if (this.usable && serviceContainer.getProperties() != null) {
                    this.params = Maps.newHashMap();
                    for (Object o : serviceContainer.getProperties().getKeys()) {
                        String key = (String)o;
                        this.params.put(key, serviceContainer.getProperty(key));
                    }
                }
            }
            catch (ObjectConfigurationException objectConfigurationException) {
                // empty catch block
            }
        }
    }
}

