/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.sharing.SharePermissionUtils;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.testkit.plugin.SearchRequestBean;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="filter")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SearchRequestBackdoor {
    private UserUtil userUtil;
    private SearchRequestService searchRequestService;
    private SearchService searchService;
    private final FavouritesService favouritesService;

    public SearchRequestBackdoor(SearchRequestService searchRequestService, UserUtil userUtil, SearchService searchService, FavouritesService favouritesService) {
        this.userUtil = userUtil;
        this.searchRequestService = searchRequestService;
        this.searchService = searchService;
        this.favouritesService = favouritesService;
    }

    @POST
    public Response createFilter(SearchRequestBean searchBean) throws SearchException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        User searcher = this.userUtil.getUser(searchBean.username);
        JiraServiceContextImpl ctx = new JiraServiceContextImpl(searcher, (ErrorCollection)errorCollection);
        SearchService.ParseResult parseResult = this.searchService.parseQuery(searcher, searchBean.searchJql);
        if (!parseResult.isValid()) {
            throw new IllegalArgumentException("This JQL you have give me, it is not so good.");
        }
        Query newQuery = parseResult.getQuery();
        SearchRequest searchRequest = new SearchRequest(newQuery, searchBean.username, searchBean.searchName, searchBean.searchDescription);
        if (StringUtils.isNotBlank((String)searchBean.jsonShareString)) {
            try {
                searchRequest.setPermissions(SharePermissionUtils.fromJsonArrayString((String)searchBean.jsonShareString));
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("This JSON share permission string you have give me, it is not so good.");
            }
        }
        SearchRequest newFilter = this.searchRequestService.createFilter((JiraServiceContext)ctx, searchRequest, false);
        return Response.ok((Object)newFilter.getId()).build();
    }

    @GET
    @Path(value="my")
    public Response my(@QueryParam(value="username") String username) {
        if ((username = StringUtils.trimToNull((String)username)) == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).entity((Object)"No user passed.").build();
        }
        User user = this.userUtil.getUser(username);
        if (user == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).entity((Object)("User '" + username + "' does not exist.")).build();
        }
        return Response.ok().cacheControl(CacheControl.never()).entity(this.asBeans(user, this.searchRequestService.getOwnedFilters(user))).build();
    }

    private Iterable<SearchRequestBean> asBeans(final User user, Iterable<? extends SearchRequest> requests) {
        return Iterables.transform(requests, (Function)new Function<SearchRequest, SearchRequestBean>(){

            public SearchRequestBean apply(SearchRequest input) {
                SearchRequestBean searchRequestBean = new SearchRequestBean();
                searchRequestBean.searchName = input.getName();
                searchRequestBean.searchJql = input.getQuery().getQueryString();
                searchRequestBean.username = input.getOwnerUserName();
                searchRequestBean.searchDescription = input.getDescription();
                searchRequestBean.favourite = SearchRequestBackdoor.this.favouritesService.isFavourite(user, (SharedEntity)input);
                searchRequestBean.favouriteCount = input.getFavouriteCount();
                try {
                    searchRequestBean.jsonShareString = SharePermissionUtils.toJsonArray((Collection)input.getPermissions().getPermissionSet()).toString();
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                return searchRequestBean;
            }
        });
    }
}

