/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldConfigurationScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.testkit.beans.FieldConfigurationSchemeBean;
import com.atlassian.jira.testkit.beans.IssueSecuritySchemeBean;
import com.atlassian.jira.testkit.beans.IssueTypeSchemeBean;
import com.atlassian.jira.testkit.beans.NotificationSchemeBean;
import com.atlassian.jira.testkit.beans.PermissionSchemeBean;
import com.atlassian.jira.testkit.beans.ProjectSchemesBean;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.plugin.beanbuilders.FieldConfigurationSchemeBeanFactory;
import com.atlassian.jira.testkit.plugin.beanbuilders.IssueSecuritySchemeBeanFactory;
import com.atlassian.jira.testkit.plugin.beanbuilders.IssueTypeSchemeBeanFactory;
import com.atlassian.jira.testkit.plugin.beanbuilders.NotificationSchemeBeanFactory;
import com.atlassian.jira.testkit.plugin.beanbuilders.PermissionSchemeBeanFactory;
import com.atlassian.jira.testkit.plugin.workflows.WorkflowSchemeDataFactory;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.regex.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="project/{projectIdOrKey}/schemes")
public class ProjectSchemesBackdoorResource {
    private static final Pattern PROJECT_ID_PATTERN = Pattern.compile("^[1-9]\\d{0,17}$");
    private final FieldLayoutManager fieldLayoutManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final NotificationSchemeManager notificationSchemeManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final ProjectManager projectManager;
    private final WorkflowSchemeDataFactory workflowSchemeDataFactory;
    private final WorkflowSchemeManager workflowSchemeManager;

    public ProjectSchemesBackdoorResource(FieldLayoutManager fieldLayoutManager, IssueSecuritySchemeManager issueSecuritySchemeManager, IssueTypeSchemeManager issueTypeSchemeManager, NotificationSchemeManager notificationSchemeManager, PermissionSchemeManager permissionSchemeManager, ProjectManager projectManager, WorkflowSchemeDataFactory workflowSchemeDataFactory, WorkflowSchemeManager workflowSchemeManager) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.notificationSchemeManager = notificationSchemeManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.projectManager = projectManager;
        this.workflowSchemeDataFactory = workflowSchemeDataFactory;
        this.workflowSchemeManager = workflowSchemeManager;
    }

    @GET
    public Response getProjectSchemes(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        if (projectIdOrKey == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"projectIdOrKey must be provided.").build();
        }
        Project project = this.getProject(projectIdOrKey);
        if (project == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"The specified project does not exist.").build();
        }
        return Response.ok((Object)new ProjectSchemesBeanBuilder().fieldConfigurationScheme(this.getFieldConfigurationScheme(project)).issueSecurityScheme(this.getIssueSecurityScheme(project)).issueTypeScheme(this.getIssueTypeScheme(project)).notificationScheme(this.getNotificationScheme(project)).permissionScheme(this.getPermissionScheme(project)).workflowScheme((WorkflowScheme)this.getWorkflowScheme(project)).build()).build();
    }

    private Project getProject(String projectIdOrKey) {
        return PROJECT_ID_PATTERN.matcher(projectIdOrKey).matches() ? this.projectManager.getProjectObj(Long.valueOf(Long.parseLong(projectIdOrKey))) : this.projectManager.getProjectObjByKey(projectIdOrKey);
    }

    private FieldConfigurationScheme getFieldConfigurationScheme(Project project) {
        return this.fieldLayoutManager.getFieldConfigurationScheme(project);
    }

    private Scheme getIssueSecurityScheme(Project project) {
        return this.issueSecuritySchemeManager.getSchemeFor(project);
    }

    private FieldConfigScheme getIssueTypeScheme(Project project) {
        return this.issueTypeSchemeManager.getConfigScheme(project);
    }

    private Scheme getNotificationScheme(Project project) {
        return this.notificationSchemeManager.getSchemeFor(project);
    }

    private Scheme getPermissionScheme(Project project) {
        return this.permissionSchemeManager.getSchemeFor(project);
    }

    private AssignableWorkflowScheme getWorkflowScheme(Project project) {
        return this.workflowSchemeManager.getWorkflowSchemeObj(project);
    }

    class ProjectSchemesBeanBuilder {
        private FieldConfigurationSchemeBean fieldConfigurationSchemeBean;
        private IssueSecuritySchemeBean issueSecuritySchemeBean;
        private IssueTypeSchemeBean issueTypeSchemeBean;
        private NotificationSchemeBean notificationSchemeBean;
        private PermissionSchemeBean permissionSchemeBean;
        private WorkflowSchemeData workflowSchemeBean;

        ProjectSchemesBeanBuilder() {
        }

        public ProjectSchemesBeanBuilder fieldConfigurationScheme(FieldConfigurationScheme fieldConfigurationScheme) {
            this.fieldConfigurationSchemeBean = FieldConfigurationSchemeBeanFactory.toFieldConfigurationSchemeBean(fieldConfigurationScheme);
            return this;
        }

        public ProjectSchemesBeanBuilder issueSecurityScheme(Scheme issueSecurityScheme) {
            this.issueSecuritySchemeBean = IssueSecuritySchemeBeanFactory.toIssueSecuritySchemeBean(issueSecurityScheme);
            return this;
        }

        public ProjectSchemesBeanBuilder issueTypeScheme(FieldConfigScheme issueTypeScheme) {
            this.issueTypeSchemeBean = IssueTypeSchemeBeanFactory.toIssueTypeSchemeBean(issueTypeScheme);
            return this;
        }

        public ProjectSchemesBeanBuilder notificationScheme(Scheme notificationScheme) {
            this.notificationSchemeBean = NotificationSchemeBeanFactory.toNotificationSchemeBean(notificationScheme);
            return this;
        }

        public ProjectSchemesBeanBuilder permissionScheme(Scheme permissionScheme) {
            this.permissionSchemeBean = PermissionSchemeBeanFactory.toPermissionSchemeBean(permissionScheme);
            return this;
        }

        public ProjectSchemesBeanBuilder workflowScheme(WorkflowScheme workflowScheme) {
            this.workflowSchemeBean = ProjectSchemesBackdoorResource.this.workflowSchemeDataFactory.toData(workflowScheme);
            return this;
        }

        public ProjectSchemesBean build() {
            return new ProjectSchemesBean(this.fieldConfigurationSchemeBean, this.issueSecuritySchemeBean, this.issueTypeSchemeBean, this.notificationSchemeBean, this.permissionSchemeBean, this.workflowSchemeBean);
        }
    }
}

