/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.testkit.plugin.EmptyErrorCollection;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Path(value="project")
@AnonymousAllowed
public class ProjectBackdoor {
    private final Logger log = Logger.getLogger(ProjectBackdoor.class);
    private final ProjectService projectService;
    private final PermissionSchemeManager permissionSchemeManager;
    private final UserUtil userUtil;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final NotificationSchemeManager notificationSchemeManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final FieldLayoutManager fieldLayoutManager;

    public ProjectBackdoor(ProjectService projectService, PermissionSchemeManager permissionSchemeManager, UserUtil userUtil, IssueTypeSchemeManager issueTypeSchemeManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, NotificationSchemeManager notificationSchemeManager, IssueSecuritySchemeManager issueSecuritySchemeManager, FieldLayoutManager fieldLayoutManager) {
        this.projectService = projectService;
        this.permissionSchemeManager = permissionSchemeManager;
        this.userUtil = userUtil;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.notificationSchemeManager = notificationSchemeManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.fieldLayoutManager = fieldLayoutManager;
    }

    @GET
    @Path(value="add")
    public Response addProject(@QueryParam(value="name") String name, @QueryParam(value="key") String key, @QueryParam(value="lead") String lead) {
        EmptyErrorCollection errorCollection = new EmptyErrorCollection();
        ProjectService.CreateProjectValidationResult result = this.projectService.validateCreateProject(this.getUserWithAdminPermission(), name, key, "This project is awesome", lead, null, Long.valueOf(2L), null);
        if (!result.isValid()) {
            this.log.error((Object)String.format("Unable to create a project '%s': %s", name, result.getErrorCollection().toString()));
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        Project project = this.projectService.createProject(result);
        Long permissionSchemeId = this.permissionSchemeManager.getDefaultSchemeObject().getId();
        ProjectService.UpdateProjectSchemesValidationResult schemesResult = new ProjectService.UpdateProjectSchemesValidationResult((ErrorCollection)errorCollection, permissionSchemeId, null, null);
        this.projectService.updateProjectSchemes(schemesResult, project);
        return Response.ok((Object)project.getId().toString()).build();
    }

    @DELETE
    @Path(value="{projectKey}")
    public Response delete(@PathParam(value="projectKey") String key) {
        User adminUser = this.getUserWithAdminPermission();
        ProjectService.DeleteProjectValidationResult deleteProjectValidationResult = this.projectService.validateDeleteProject(adminUser, key);
        if (!deleteProjectValidationResult.isValid()) {
            return Response.serverError().cacheControl(CacheControl.never()).build();
        }
        this.projectService.deleteProject(adminUser, deleteProjectValidationResult);
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="permissionScheme/set")
    public Response setPermissionScheme(@QueryParam(value="project") long projectId, @QueryParam(value="scheme") long schemeId) {
        User admin = this.getUserWithAdminPermission();
        Scheme scheme = this.permissionSchemeManager.getSchemeObject(Long.valueOf(schemeId));
        Project project = this.projectService.getProjectById(admin, Long.valueOf(projectId)).getProject();
        this.permissionSchemeManager.removeSchemesFromProject(project);
        this.permissionSchemeManager.addSchemeToProject(project, scheme);
        return Response.ok().build();
    }

    @GET
    @Path(value="notificationScheme/set")
    public Response setNotificationScheme(@QueryParam(value="project") long projectId, @QueryParam(value="scheme") Long schemeId) {
        User admin = this.getUserWithAdminPermission();
        Project project = this.projectService.getProjectById(admin, Long.valueOf(projectId)).getProject();
        this.notificationSchemeManager.removeSchemesFromProject(project);
        if (schemeId != null) {
            Scheme scheme = this.notificationSchemeManager.getSchemeObject(schemeId);
            this.notificationSchemeManager.addSchemeToProject(project, scheme);
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="issueSecurityScheme/set")
    public Response setIssueSecurityScheme(@QueryParam(value="project") long projectId, @QueryParam(value="scheme") Long schemeId) {
        User admin = this.getUserWithAdminPermission();
        Project project = this.projectService.getProjectById(admin, Long.valueOf(projectId)).getProject();
        this.issueSecuritySchemeManager.removeSchemesFromProject(project);
        if (schemeId != null) {
            Scheme scheme = this.issueSecuritySchemeManager.getSchemeObject(schemeId);
            this.issueSecuritySchemeManager.addSchemeToProject(project, scheme);
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="fieldConfigurationScheme/add")
    public Response addFieldConfigurationScheme(@QueryParam(value="project") long projectId, @QueryParam(value="scheme") Long schemeId) {
        User admin = this.getUserWithAdminPermission();
        Project project = this.projectService.getProjectById(admin, Long.valueOf(projectId)).getProject();
        this.fieldLayoutManager.addSchemeAssociation(project, schemeId);
        return Response.ok().build();
    }

    @GET
    @Path(value="fieldConfigurationScheme/remove")
    public Response deleteFieldConfigurationScheme(@QueryParam(value="project") long projectId, @QueryParam(value="scheme") Long schemeId) {
        User admin = this.getUserWithAdminPermission();
        Project project = this.projectService.getProjectById(admin, Long.valueOf(projectId)).getProject();
        this.fieldLayoutManager.removeSchemeAssociation(project, schemeId);
        return Response.ok().build();
    }

    private User getUserWithAdminPermission() {
        return this.userUtil.getUser("admin");
    }

    @GET
    @Path(value="defaultIssueType/set")
    public Response setDefaultIssueType(@QueryParam(value="project") long projectId, @QueryParam(value="issueTypeId") String issueTypeId) {
        User admin = this.getUserWithAdminPermission();
        Project project = this.projectService.getProjectById(admin, Long.valueOf(projectId)).getProject();
        FieldConfigScheme issueTypeScheme = this.issueTypeSchemeManager.getConfigScheme(project);
        this.issueTypeSchemeManager.setDefaultValue(issueTypeScheme.getOneAndOnlyConfig(), issueTypeId);
        return Response.ok(null).build();
    }

    @GET
    @Path(value="issueTypeScreenScheme/set")
    public Response setIssueTypeScreenScheme(@QueryParam(value="project") long projectId, @QueryParam(value="issueTypeScreenScheme") long issueTypeScreenSchemeId) {
        User admin = this.getUserWithAdminPermission();
        Project project = this.projectService.getProjectById(admin, Long.valueOf(projectId)).getProject();
        IssueTypeScreenScheme issueTypeScreenScheme = this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(Long.valueOf(issueTypeScreenSchemeId));
        this.issueTypeScreenSchemeManager.addSchemeAssociation(project.getGenericValue(), issueTypeScreenScheme);
        return Response.ok(null).build();
    }

    @GET
    @Path(value="projectLead/set")
    public Response setAutomaticAssignee(@QueryParam(value="project") long projectId, @QueryParam(value="username") String username) {
        User admin = this.getUserWithAdminPermission();
        User newProjectLead = this.userUtil.getUser(username);
        Project project = this.projectService.getProjectById(admin, Long.valueOf(projectId)).getProject();
        ProjectService.UpdateProjectValidationResult result = this.projectService.validateUpdateProject(admin, project.getName(), project.getKey(), project.getDescription(), newProjectLead.getName(), project.getUrl(), project.getAssigneeType(), project.getAvatar().getId());
        if (!result.isValid()) {
            return Response.serverError().build();
        }
        this.projectService.updateProject(result);
        return Response.ok(null).build();
    }

    @GET
    @Path(value="defaultAssignee/set")
    public Response setAutomaticAssignee(@QueryParam(value="project") long projectId, @QueryParam(value="setToProjectLead") boolean setToProjectLead) {
        Project project;
        ProjectService.UpdateProjectValidationResult result;
        User admin = this.getUserWithAdminPermission();
        long assignee = 2L;
        if (!setToProjectLead) {
            assignee = 3L;
        }
        if (!(result = this.projectService.validateUpdateProject(admin, (project = this.projectService.getProjectById(admin, Long.valueOf(projectId)).getProject()).getName(), project.getKey(), project.getDescription(), project.getLead().getName(), project.getUrl(), Long.valueOf(assignee), project.getAvatar().getId())).isValid()) {
            return Response.serverError().build();
        }
        this.projectService.updateProject(result);
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="delete")
    @Produces(value={"application/json"})
    public Response deleteProject(@QueryParam(value="key") String key) {
        User admin = this.userUtil.getUser("admin");
        Project project = this.projectService.getProjectByKey(admin, key).getProject();
        if (project != null) {
            EmptyErrorCollection errorCollection = new EmptyErrorCollection();
            ProjectService.DeleteProjectValidationResult result = new ProjectService.DeleteProjectValidationResult((ErrorCollection)errorCollection, project);
            ProjectService.DeleteProjectResult projectResult = this.projectService.deleteProject(admin, result);
            return Response.ok((Object)projectResult.isValid()).build();
        }
        return Response.ok((Object)false).build();
    }
}

