/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraPermission;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="permissions")
public class PermissionsBackdoor {
    private final GlobalPermissionManager globalPermissionManager;

    public PermissionsBackdoor(GlobalPermissionManager globalPermissionManager) {
        this.globalPermissionManager = globalPermissionManager;
    }

    @GET
    @AnonymousAllowed
    @Path(value="global/add")
    public Response addGlobalPermission(@QueryParam(value="type") int permissionType, @QueryParam(value="group") String group) {
        this.globalPermissionManager.addPermission(permissionType, group);
        return Response.ok(null).build();
    }

    @GET
    @Path(value="global")
    public Collection<PermissionBean> getPermissions(@QueryParam(value="type") Integer permissionType) {
        if (permissionType == null) {
            throw new WebApplicationException(400);
        }
        return Collections2.transform((Collection)this.globalPermissionManager.getPermissions(permissionType.intValue()), PermissionBean.CONVERT_FN);
    }

    @GET
    @AnonymousAllowed
    @Path(value="global/remove")
    public Response removeGlobalPermission(@QueryParam(value="type") int permissionType, @QueryParam(value="group") String group) {
        this.globalPermissionManager.removePermission(permissionType, group);
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json"})
    @Path(value="global/getgroups")
    public Response getGlobalPermissionGroups(@QueryParam(value="type") int permissionType) {
        ArrayList<String> groupNames = new ArrayList<String>();
        for (JiraPermission jiraPermission : this.globalPermissionManager.getPermissions(permissionType)) {
            groupNames.add(jiraPermission.getGroup());
        }
        ArrayList str = Lists.newArrayListWithCapacity((int)groupNames.size());
        str.addAll(groupNames);
        return Response.ok((Object)str).cacheControl(CacheControl.never()).build();
    }

    public static class PermissionBean {
        static Function<JiraPermission, PermissionBean> CONVERT_FN = new Function<JiraPermission, PermissionBean>(){

            public PermissionBean apply(JiraPermission jiraPermission) {
                PermissionBean permissionBean = new PermissionBean();
                permissionBean.permType = jiraPermission.getPermType();
                permissionBean.group = jiraPermission.getGroup();
                return permissionBean;
            }
        };
        public String permType;
        public String group;
    }
}

