/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@Path(value="permissionSchemes")
@Produces(value={"application/json"})
public class PermissionSchemesBackdoor {
    private PermissionSchemeManager schemeManager;

    public PermissionSchemesBackdoor(PermissionSchemeManager schemeManager) {
        this.schemeManager = schemeManager;
    }

    @GET
    @AnonymousAllowed
    @Path(value="copyDefault")
    public Response copyDefault(@QueryParam(value="schemeName") String newSchemeName) {
        Scheme defaultScheme = this.schemeManager.getDefaultSchemeObject();
        Scheme copyScheme = this.schemeManager.copyScheme(defaultScheme);
        copyScheme.setName(newSchemeName);
        this.schemeManager.updateScheme(copyScheme);
        return Response.ok((Object)copyScheme.getId()).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="create")
    public Response create(@QueryParam(value="schemeName") String newSchemeName, @QueryParam(value="schemeDescription") String description) {
        Scheme copyScheme = this.schemeManager.createSchemeObject(newSchemeName, description);
        return Response.ok((Object)copyScheme.getId()).build();
    }

    @DELETE
    @Path(value="{schemeId}")
    public Response delete(@PathParam(value="schemeId") Long schemeId) {
        try {
            this.schemeManager.deleteScheme(schemeId);
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="entity/add")
    public Response addSchemeEntity(@QueryParam(value="schemeId") long schemeId, @QueryParam(value="permission") long permission, @QueryParam(value="type") String type, @QueryParam(value="parameter") String parameter) {
        try {
            GenericValue scheme = this.schemeManager.getScheme(Long.valueOf(schemeId));
            List entities = this.schemeManager.getEntities(scheme, Long.valueOf(permission), type, parameter);
            if (!entities.isEmpty()) {
                throw new IllegalStateException("PermissionScheme entity to be added already exists");
            }
            SchemeEntity entity = new SchemeEntity(type, parameter, (Object)permission);
            this.schemeManager.createSchemeEntity(scheme, entity);
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="entity/remove")
    public Response removeEntity(@QueryParam(value="schemeId") long schemeId, @QueryParam(value="permission") long permission, @QueryParam(value="type") String type, @QueryParam(value="parameter") String parameter) {
        try {
            GenericValue scheme = this.schemeManager.getScheme(Long.valueOf(schemeId));
            List entities = this.schemeManager.getEntities(scheme, Long.valueOf(permission), type, parameter);
            if (entities.isEmpty()) {
                throw new IllegalStateException("PermissionScheme entity to be removed does not exist");
            }
            for (GenericValue entity : entities) {
                Long id = entity.getLong("id");
                this.schemeManager.deleteEntity(id);
            }
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="entity/replace")
    public Response replaceEntities(@QueryParam(value="schemeId") long schemeId, @QueryParam(value="permission") long permission, @QueryParam(value="type") String type, @QueryParam(value="parameter") String parameter) {
        try {
            GenericValue scheme = this.schemeManager.getScheme(Long.valueOf(schemeId));
            List entities = this.schemeManager.getEntities(scheme, Long.valueOf(permission));
            for (GenericValue entity : entities) {
                Long id = entity.getLong("id");
                this.schemeManager.deleteEntity(id);
            }
            SchemeEntity entity = new SchemeEntity(type, parameter, (Object)permission);
            this.schemeManager.createSchemeEntity(scheme, entity);
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
        return Response.ok(null).build();
    }
}

