/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Preconditions;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="config-info")
@Produces(value={"application/json"})
public class JiraConfigInfo {
    private final JiraHome jiraHome;
    private final ApplicationProperties applicationProperties;

    public JiraConfigInfo(JiraHome jiraHome, ApplicationProperties applicationProperties) {
        this.jiraHome = (JiraHome)Preconditions.checkNotNull((Object)jiraHome);
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
    }

    @GET
    @AnonymousAllowed
    public Response getConfigInfo() {
        return Response.ok((Object)new ConfigInfoBean(this.jiraHome, this.applicationProperties)).build();
    }

    @XmlRootElement
    public static class ConfigInfoBean {
        @XmlElement
        private String jiraHomePath;
        @XmlElement
        private boolean isSetUp;

        public ConfigInfoBean() {
        }

        public ConfigInfoBean(JiraHome home, ApplicationProperties props) {
            this.jiraHomePath = home.getHomePath();
            this.isSetUp = props.getOption("jira.setup");
        }
    }
}

