/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.jira.testkit.plugin.util.Errors;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonProperty;

@Path(value="issueType")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueTypeBackdoorResource {
    private static final String SUBTASK = "jira_subtask";
    private static final String TASK = "";
    private final ConstantsManager constantsManager;
    private final IssueTypeManager issueTypeManager;

    public IssueTypeBackdoorResource(ConstantsManager constantsManager, IssueTypeManager issueTypeManager) {
        this.constantsManager = constantsManager;
        this.issueTypeManager = issueTypeManager;
    }

    @GET
    public Response getAllTypes() {
        Collection issueTypes = this.constantsManager.getAllIssueTypeObjects();
        ArrayList issueTypeBeans = Lists.newArrayList();
        for (IssueType issueType : issueTypes) {
            issueTypeBeans.add(new IssueTypeBean(issueType));
        }
        return Response.ok((Object)issueTypeBeans).cacheControl(CacheControl.never()).build();
    }

    @POST
    public Response createIssueType(IssueTypeBean bean) {
        String style = bean.subtask ? SUBTASK : TASK;
        SimpleErrorCollection collections = new SimpleErrorCollection();
        this.constantsManager.validateCreateIssueType(bean.name, style, bean.description, bean.iconUrl, (ErrorCollection)collections, "name");
        if (collections.hasAnyErrors()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).entity((Object)Errors.of((ErrorCollection)collections)).build();
        }
        IssueType type = bean.subtask ? this.issueTypeManager.createSubTaskIssueType(bean.name, bean.description, bean.iconUrl) : this.issueTypeManager.createIssueType(bean.name, bean.description, bean.iconUrl);
        return Response.ok((Object)new IssueTypeBean(type)).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{id}")
    public Response deleteIssueType(@PathParam(value="id") long id) {
        this.issueTypeManager.removeIssueType(String.valueOf(id), null);
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    public static class IssueTypeBean {
        @JsonProperty
        private String id;
        @JsonProperty
        private String description;
        @JsonProperty
        private String iconUrl;
        @JsonProperty
        private String name;
        @JsonProperty
        private boolean subtask;

        public IssueTypeBean() {
        }

        public IssueTypeBean(IssueType type) {
            this.id = StringUtils.trimToNull((String)type.getId());
            this.name = StringUtils.trimToNull((String)type.getName());
            this.iconUrl = StringUtils.trimToNull((String)type.getIconUrl());
            this.description = StringUtils.trimToNull((String)type.getDescription());
            this.subtask = type.isSubTask();
        }
    }
}

