/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.ofbiz.core.entity.GenericEntityException;

@Path(value="issueSecuritySchemes")
@Produces(value={"application/json"})
public class IssueSecuritySchemesBackdoor {
    private IssueSecuritySchemeManager schemeManager;

    public IssueSecuritySchemesBackdoor(IssueSecuritySchemeManager schemeManager) {
        this.schemeManager = schemeManager;
    }

    @GET
    @AnonymousAllowed
    @Path(value="create")
    public Response create(@QueryParam(value="schemeName") String newSchemeName, @QueryParam(value="schemeDescription") String description) {
        Scheme copyScheme = this.schemeManager.createSchemeObject(newSchemeName, description);
        return Response.ok((Object)copyScheme.getId()).build();
    }

    @DELETE
    @Path(value="{schemeId}")
    public Response delete(@PathParam(value="schemeId") Long schemeId) {
        try {
            this.schemeManager.deleteScheme(schemeId);
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }
}

