/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.context.ProjectContext;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="fieldConfiguration")
public class FieldConfigurationBackdoor {
    private final FieldLayoutManager fieldLayoutManager;
    private final CustomFieldManager customFieldManager;
    private final ProjectManager projectManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;

    public FieldConfigurationBackdoor(FieldLayoutManager fieldLayoutManager, CustomFieldManager customFieldManager, ProjectManager projectManager, FieldConfigSchemeManager fieldConfigSchemeManager) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.customFieldManager = customFieldManager;
        this.projectManager = projectManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
    }

    @GET
    @AnonymousAllowed
    @Path(value="hideField")
    public Response hideField(@QueryParam(value="name") String fieldConfigName, @QueryParam(value="fieldId") String fieldId) {
        EditableFieldLayout fieldLayout = this.getFieldLayout(fieldConfigName);
        if (fieldLayout.getId() == null || fieldLayout.getId() == 10000L) {
            EditableDefaultFieldLayout editableDefaultFieldLayout = this.fieldLayoutManager.getEditableDefaultFieldLayout();
            editableDefaultFieldLayout.hide(editableDefaultFieldLayout.getFieldLayoutItem(fieldId));
            this.fieldLayoutManager.storeEditableDefaultFieldLayout(editableDefaultFieldLayout);
        } else {
            fieldLayout.hide(fieldLayout.getFieldLayoutItem(fieldId));
            this.fieldLayoutManager.storeEditableFieldLayout(fieldLayout);
        }
        return Response.ok().build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="showField")
    public Response showField(@QueryParam(value="name") String fieldConfigName, @QueryParam(value="fieldId") String fieldId) {
        EditableFieldLayout fieldLayout = this.getFieldLayout(fieldConfigName);
        if (fieldLayout.getId() == null || fieldLayout.getId() == 10000L) {
            EditableDefaultFieldLayout editableDefaultFieldLayout = this.fieldLayoutManager.getEditableDefaultFieldLayout();
            editableDefaultFieldLayout.show(editableDefaultFieldLayout.getFieldLayoutItem(fieldId));
            this.fieldLayoutManager.storeEditableDefaultFieldLayout(editableDefaultFieldLayout);
        } else {
            fieldLayout.show(fieldLayout.getFieldLayoutItem(fieldId));
            this.fieldLayoutManager.storeEditableFieldLayout(fieldLayout);
        }
        return Response.ok().build();
    }

    @POST
    @AnonymousAllowed
    @Path(value="changeFieldVisibility")
    public Response changeFieldVisibility(@QueryParam(value="fieldConfigurationName") String configurationName, @QueryParam(value="fieldName") String fieldName, @QueryParam(value="hide") boolean hide) {
        EditableFieldLayout editableFieldLayout = this.getFieldLayout(configurationName);
        FieldLayoutItem fieldLayoutItem = editableFieldLayout.getFieldLayoutItem(fieldName);
        if (hide) {
            editableFieldLayout.hide(fieldLayoutItem);
        } else {
            editableFieldLayout.show(fieldLayoutItem);
        }
        if (editableFieldLayout.isDefault()) {
            this.fieldLayoutManager.storeEditableDefaultFieldLayout((EditableDefaultFieldLayout)editableFieldLayout);
        } else {
            this.fieldLayoutManager.storeEditableFieldLayout(editableFieldLayout);
        }
        return Response.ok().build();
    }

    @POST
    @AnonymousAllowed
    @Path(value="associateCustomFieldWithProject")
    public Response associateCustomFieldWithProject(@QueryParam(value="fieldId") String fieldId, @QueryParam(value="projectName") String projectName) {
        CustomField customField = this.customFieldManager.getCustomFieldObject(fieldId);
        FieldConfigScheme fieldConfigScheme = (FieldConfigScheme)customField.getConfigurationSchemes().get(0);
        Project project = this.projectManager.getProjectObjByName(projectName);
        this.fieldConfigSchemeManager.updateFieldConfigScheme(fieldConfigScheme, (List)ImmutableList.of((Object)new ProjectContext(project, null)), (ConfigurableField)customField);
        this.customFieldManager.refreshConfigurationSchemes(customField.getIdAsLong());
        return Response.ok().build();
    }

    protected final EditableFieldLayout getFieldLayout(String fieldConfigName) {
        List editableFieldLayouts = this.fieldLayoutManager.getEditableFieldLayouts();
        for (EditableFieldLayout editableFieldLayout : editableFieldLayouts) {
            if (!fieldConfigName.equalsIgnoreCase(editableFieldLayout.getName())) continue;
            return editableFieldLayout;
        }
        return null;
    }
}

