/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.testkit.plugin.EventWatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.commons.lang.builder.ToStringBuilder;

public class EventWatcherImpl
implements EventWatcher,
Startable {
    private final EventPublisher eventPublisher;
    private final CircularFifoBuffer events = new CircularFifoBuffer();

    public EventWatcherImpl(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @EventListener
    public void listen(Object object) {
        CircularFifoBuffer circularFifoBuffer = this.events;
        synchronized (circularFifoBuffer) {
            this.events.add((Object)new Event(object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getEvents() {
        CircularFifoBuffer circularFifoBuffer = this.events;
        synchronized (circularFifoBuffer) {
            Collection transform = Collections2.transform((Collection)this.events, (Function)Functions.toStringFunction());
            return ImmutableList.copyOf((Iterable)transform);
        }
    }

    @XmlType
    public static class Event {
        @XmlElement
        public String timestamp;
        @XmlElement
        public String source;
        @XmlElement
        public String description;

        public Event() {
        }

        public Event(Object event) {
            this.source = event.getClass().toString();
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
            this.timestamp = sdf.format(new Date());
            try {
                this.description = ToStringBuilder.reflectionToString((Object)event);
            }
            catch (RuntimeException ignored1) {
                try {
                    this.description = event.toString();
                }
                catch (RuntimeException ignored2) {
                    this.description = String.format("%s@%d", event.getClass().getName(), System.identityHashCode(event));
                }
            }
        }

        public String toString() {
            return String.format("%s: [%s] %s", this.timestamp, this.source, this.description);
        }
    }
}

