/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.portal.PortletConfigurationManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/dashboard")
public class DashboardBackdoor {
    private final PortalPageService portalPageService;
    private final FavouritesService favouritesService;
    private final PortletConfigurationManager portletConfigurationManager;
    private final UserUtil userUtil;

    public DashboardBackdoor(PortalPageService portalPageService, UserUtil userUtil, FavouritesService favouritesService, PortletConfigurationManager portletConfigurationManager) {
        this.portalPageService = portalPageService;
        this.userUtil = userUtil;
        this.favouritesService = favouritesService;
        this.portletConfigurationManager = portletConfigurationManager;
    }

    @GET
    @Path(value="my")
    public Response getMyDasbhoards(@QueryParam(value="username") String username) {
        if ((username = StringUtils.trimToNull((String)username)) == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).entity((Object)"No user passed.").build();
        }
        User user = this.userUtil.getUser(username);
        if (user == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).entity((Object)("User '" + username + "' does not exist.")).build();
        }
        return Response.ok().cacheControl(CacheControl.never()).entity(this.asBeans(user, this.portalPageService.getOwnedPortalPages(user))).build();
    }

    @GET
    @Path(value="emptySystemDashboard")
    public Response emptySystemDashboard() {
        PortalPage systemDashboard = this.portalPageService.getSystemDefaultPortalPage();
        List portlets = this.portletConfigurationManager.getByPortalPage(systemDashboard.getId());
        for (PortletConfiguration pc : portlets) {
            this.portletConfigurationManager.delete(pc);
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    private Iterable<PortalPageBean> asBeans(final User user, Iterable<? extends PortalPage> portalPages) {
        return Iterables.transform(portalPages, (Function)new Function<PortalPage, PortalPageBean>(){

            public PortalPageBean apply(PortalPage input) {
                return new PortalPageBean(input, DashboardBackdoor.this.favouritesService.isFavourite(user, (SharedEntity)input));
            }
        });
    }

    @JsonAutoDetect
    public static class PortalPageBean {
        private Long id;
        private String name;
        private String owner;
        private String description;
        private Long favouriteCount;
        private boolean favourite;

        public PortalPageBean() {
        }

        public PortalPageBean(PortalPage page, boolean favourite) {
            this.id = page.getId();
            this.name = page.getName();
            this.description = page.getDescription();
            this.owner = page.getOwnerUserName();
            this.favouriteCount = page.getFavouriteCount();
            this.favourite = favourite;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getOwner() {
            return this.owner;
        }

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Long getFavouriteCount() {
            return this.favouriteCount;
        }

        public void setFavouriteCount(Long favouriteCount) {
            this.favouriteCount = favouriteCount;
        }

        public boolean isFavourite() {
            return this.favourite;
        }

        public void setFavourite(boolean favourite) {
            this.favourite = favourite;
        }
    }
}

