/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="darkFeatures")
public class DarkFeaturesBackdoor {
    @GET
    @AnonymousAllowed
    @Path(value="user/enable")
    public Response enableForUser(@QueryParam(value="username") String username, @QueryParam(value="feature") String feature) {
        User user = ComponentAccessor.getUserUtil().getUser(username);
        this.getFeatureManager().enableUserDarkFeature(user, feature);
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="user/disable")
    public Response disableForUser(@QueryParam(value="username") String username, @QueryParam(value="feature") String feature) {
        User user = ComponentAccessor.getUserUtil().getUser(username);
        this.getFeatureManager().disableUserDarkFeature(user, feature);
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="site/enable")
    public Response enableForSite(@QueryParam(value="feature") String feature) {
        this.getFeatureManager().enableSiteDarkFeature(feature);
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="site/disable")
    public Response disableForSite(@QueryParam(value="feature") String feature) {
        this.getFeatureManager().disableSiteDarkFeature(feature);
        return Response.ok(null).build();
    }

    @GET
    @AnonymousAllowed
    @Path(value="global/enabled")
    public Response isEnabled(@QueryParam(value="feature") String feature) {
        boolean isEnabled = this.getFeatureManager().getDarkFeatures().getGlobalEnabledFeatureKeys().contains(feature);
        return Response.ok((Object)Boolean.toString(isEnabled)).build();
    }

    private FeatureManager getFeatureManager() {
        return (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class);
    }
}

