/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.auditing.AuditingManager;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.ofbiz.core.entity.GenericValue;

@Path(value="auditing")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AuditingBackdoor {
    private static String ENTITY_NAME = "AuditLog";
    private static String ITEMS_ENTITY_NAME = "AuditItem";
    private static String CHANGED_VALUES_ENTITY_NAME = "AuditChangedValue";
    private final AuditingManager auditingManager;
    private final OfBizDelegator ofBizDelegator;

    public AuditingBackdoor(AuditingManager auditingManager, OfBizDelegator ofBizDelegator) {
        this.auditingManager = auditingManager;
        this.ofBizDelegator = ofBizDelegator;
    }

    @GET
    @Path(value="enable")
    public Response enable() {
        try {
            this.auditingManager.setAuditingEnabled(true);
        }
        catch (PermissionException e) {
            throw new RuntimeException(e);
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="disable")
    public Response disable() {
        try {
            this.auditingManager.setAuditingEnabled(false);
        }
        catch (PermissionException e) {
            throw new RuntimeException(e);
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="clearAll")
    public Response clearAll() {
        List records = this.ofBizDelegator.findAll(ENTITY_NAME);
        if (records != null) {
            for (GenericValue record : records) {
                this.ofBizDelegator.removeRelated("Child" + ITEMS_ENTITY_NAME, record);
                this.ofBizDelegator.removeRelated("Child" + CHANGED_VALUES_ENTITY_NAME, record);
                this.ofBizDelegator.removeValue(record);
            }
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }
}

