/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.plugin;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.testkit.plugin.util.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="attachments")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AttachmentsBackdoor {
    private final ApplicationProperties applicationProperties;
    private final AttachmentPathManager attachmentPathManager;

    public AttachmentsBackdoor(ApplicationProperties applicationProperties, AttachmentPathManager attachmentPathManager) {
        this.applicationProperties = applicationProperties;
        this.attachmentPathManager = attachmentPathManager;
    }

    @GET
    @Path(value="enable")
    public Response enable() {
        this.attachmentPathManager.setUseDefaultDirectory();
        this.applicationProperties.setOption("jira.option.allowattachments", true);
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="disable")
    public Response disable() {
        this.attachmentPathManager.disableAttachments();
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="attachmentPath")
    public Response attachmentPath() {
        return Response.ok((Object)(this.attachmentPathManager.getUseDefaultDirectory() ? this.attachmentPathManager.getDefaultAttachmentPath() : this.attachmentPathManager.getAttachmentPath())).build();
    }
}

