/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.testkit.beans;

import com.atlassian.jira.testkit.beans.CustomFieldOption;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CustomFieldConfig {
    private Set<String> projects = Sets.newHashSet();
    private Set<String> issueTypes = Sets.newHashSet();
    private List<CustomFieldOption> options = Lists.newArrayList();

    public static Predicate<CustomFieldConfig> isGlobalPredicate() {
        return new Predicate<CustomFieldConfig>(){

            public boolean apply(CustomFieldConfig input) {
                return input.isGlobal();
            }
        };
    }

    @JsonProperty
    public Set<String> getIssueTypes() {
        return this.issueTypes;
    }

    public void setIssueTypes(Set<String> issueTypes) {
        this.issueTypes = issueTypes;
    }

    @JsonProperty
    public List<CustomFieldOption> getOptions() {
        return this.options;
    }

    public void setOptions(List<CustomFieldOption> options) {
        this.options = options;
    }

    @JsonProperty
    public Set<String> getProjects() {
        return this.projects;
    }

    public void setProjects(Set<String> projects) {
        this.projects = projects;
    }

    @JsonIgnore
    public boolean isGlobal() {
        return this.projects.isEmpty() && this.issueTypes.isEmpty();
    }
}

