/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.Version;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import java.net.URI;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public class VersionJsonParser
implements JsonParser<Version> {
    @Override
    public Version parse(JSONObject json) throws JSONException {
        URI self = JsonParseUtil.getSelfUri(json);
        String name = json.getString("name");
        String description = JsonParseUtil.getNullableString(json, "description");
        boolean isArchived = json.getBoolean("archived");
        boolean isReleased = json.getBoolean("released");
        DateTime releaseDate = JsonParseUtil.parseOptionalDateTime(json, "releaseDate");
        return new Version(self, name, description, isArchived, isReleased, releaseDate);
    }
}

