/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.ExpandableProperty;
import com.atlassian.jira.rest.client.RestClientException;
import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class JsonParseUtil {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = ISODateTimeFormat.dateTime();
    public static final String VALUE_KEY = "value";

    public static <T> Collection<T> parseJsonArray(JSONArray jsonArray, JsonParser<T> jsonParser) throws JSONException {
        ArrayList<T> res = new ArrayList<T>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            res.add(jsonParser.parse(jsonArray.getJSONObject(i)));
        }
        return res;
    }

    public static <T> ExpandableProperty<T> parseExpandableProperty(JSONObject json, JsonParser<T> expandablePropertyBuilder) throws JSONException {
        ArrayList<T> items;
        int numItems = json.getInt("size");
        JSONArray itemsJa = json.getJSONArray("items");
        if (itemsJa.length() > 0) {
            items = new ArrayList<T>(numItems);
            for (int i = 0; i < itemsJa.length(); ++i) {
                T item = expandablePropertyBuilder.parse(itemsJa.getJSONObject(i));
                items.add(item);
            }
        } else {
            items = null;
        }
        return new ExpandableProperty(numItems, items);
    }

    public static URI getSelfUri(JSONObject jsonObject) throws JSONException {
        return JsonParseUtil.parseURI(jsonObject.getString("self"));
    }

    public static JSONObject getNestedObject(JSONObject json, String ... path) throws JSONException {
        for (String s : path) {
            json = json.getJSONObject(s);
        }
        return json;
    }

    @Nullable
    public static JSONObject getNestedOptionalObject(JSONObject json, String ... path) throws JSONException {
        for (int i = 0; i < path.length - 1; ++i) {
            String s = path[i];
            json = json.getJSONObject(s);
        }
        return json.optJSONObject(path[path.length - 1]);
    }

    public static JSONArray getNestedArray(JSONObject json, String ... path) throws JSONException {
        for (int i = 0; i < path.length - 1; ++i) {
            String s = path[i];
            json = json.getJSONObject(s);
        }
        return json.getJSONArray(path[path.length - 1]);
    }

    public static JSONArray getNestedOptionalArray(JSONObject json, String ... path) throws JSONException {
        for (int i = 0; i < path.length - 1; ++i) {
            String s = path[i];
            json = json.getJSONObject(s);
        }
        return json.optJSONArray(path[path.length - 1]);
    }

    public static String getNestedString(JSONObject json, String ... path) throws JSONException {
        for (int i = 0; i < path.length - 1; ++i) {
            String s = path[i];
            json = json.getJSONObject(s);
        }
        return json.getString(path[path.length - 1]);
    }

    public static boolean getNestedBoolean(JSONObject json, String ... path) throws JSONException {
        for (int i = 0; i < path.length - 1; ++i) {
            String s = path[i];
            json = json.getJSONObject(s);
        }
        return json.getBoolean(path[path.length - 1]);
    }

    public static URI parseURI(String str) {
        try {
            return new URI(str);
        }
        catch (URISyntaxException e) {
            throw new RestClientException(e);
        }
    }

    @Nullable
    public static URI parseOptionalURI(JSONObject jsonObject, String attributeName) {
        String s = jsonObject.optString(attributeName, null);
        return s != null ? JsonParseUtil.parseURI(s) : null;
    }

    public static BasicUser parseBasicUser(JSONObject json) throws JSONException {
        return new BasicUser(JsonParseUtil.getSelfUri(json), json.getString("name"), json.optString("displayName", null));
    }

    public static DateTime parseDateTime(JSONObject jsonObject, String attributeName) throws JSONException {
        return JsonParseUtil.parseDateTime(jsonObject.getString(attributeName));
    }

    @Nullable
    public static DateTime parseOptionalDateTime(JSONObject jsonObject, String attributeName) throws JSONException {
        String s = jsonObject.optString(attributeName, null);
        return s != null ? JsonParseUtil.parseDateTime(s) : null;
    }

    public static DateTime parseDateTime(String str) {
        try {
            return DATE_TIME_FORMATTER.parseDateTime(str);
        }
        catch (Exception e) {
            throw new RestClientException(e);
        }
    }

    @Nullable
    public static String getNullableString(JSONObject jsonObject, String attributeName) throws JSONException {
        Object o = jsonObject.get(attributeName);
        if (o == JSONObject.NULL) {
            return null;
        }
        return o.toString();
    }

    @Nullable
    public static String getOptionalString(JSONObject jsonObject, String attributeName) {
        return jsonObject.optString(attributeName, null);
    }

    public static Collection<String> toStringCollection(JSONArray jsonArray) throws JSONException {
        ArrayList<String> res = new ArrayList<String>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            res.add(jsonArray.getString(i));
        }
        return res;
    }
}

