/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.jersey;

import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.RestClientException;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.client.apache.ApacheHttpClient;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public abstract class AbstractJerseyRestClient {
    protected final ApacheHttpClient client;
    protected final URI baseUri;

    public AbstractJerseyRestClient(URI baseUri, ApacheHttpClient client) {
        this.baseUri = baseUri;
        this.client = client;
    }

    protected <T> T invoke(Callable<T> callable) throws RestClientException {
        try {
            return callable.call();
        }
        catch (UniformInterfaceException e) {
            try {
                String body = (String)e.getResponse().getEntity(String.class);
                Collection<String> errorMessages = AbstractJerseyRestClient.extractErrors(body);
                throw new RestClientException(errorMessages, (Throwable)e);
            }
            catch (JSONException e1) {
                throw new RestClientException(e);
            }
        }
        catch (RestClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestClientException(e);
        }
    }

    protected <T> T getAndParse(final URI uri, final JsonParser<T> parser, ProgressMonitor progressMonitor) {
        return this.invoke(new Callable<T>(){

            @Override
            public T call() throws Exception {
                WebResource webResource = AbstractJerseyRestClient.this.client.resource(uri);
                JSONObject s = (JSONObject)webResource.get(JSONObject.class);
                return parser.parse(s);
            }
        });
    }

    static Collection<String> extractErrors(String body) throws JSONException {
        JSONArray valuesJsonArray;
        JSONObject errorJsonObject;
        JSONObject jsonObject = new JSONObject(body);
        ArrayList<String> errorMessages = new ArrayList<String>();
        JSONArray errorMessagesJsonArray = jsonObject.optJSONArray("errorMessages");
        if (errorMessagesJsonArray != null) {
            errorMessages.addAll(JsonParseUtil.toStringCollection(errorMessagesJsonArray));
        }
        if ((errorJsonObject = jsonObject.optJSONObject("errors")) != null && (valuesJsonArray = errorJsonObject.toJSONArray(errorJsonObject.names())) != null) {
            errorMessages.addAll(JsonParseUtil.toStringCollection(valuesJsonArray));
        }
        return errorMessages;
    }
}

