/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.domain;

import com.atlassian.jira.rest.client.AddressableEntity;
import com.atlassian.jira.rest.client.ExpandableResource;
import com.atlassian.jira.rest.client.domain.Attachment;
import com.atlassian.jira.rest.client.domain.BasicComponent;
import com.atlassian.jira.rest.client.domain.BasicIssueType;
import com.atlassian.jira.rest.client.domain.BasicPriority;
import com.atlassian.jira.rest.client.domain.BasicProject;
import com.atlassian.jira.rest.client.domain.BasicResolution;
import com.atlassian.jira.rest.client.domain.BasicStatus;
import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.domain.BasicVotes;
import com.atlassian.jira.rest.client.domain.BasicWatchers;
import com.atlassian.jira.rest.client.domain.Comment;
import com.atlassian.jira.rest.client.domain.Field;
import com.atlassian.jira.rest.client.domain.IssueLink;
import com.atlassian.jira.rest.client.domain.Version;
import com.atlassian.jira.rest.client.domain.Worklog;
import com.google.common.base.Objects;
import java.net.URI;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.joda.time.DateTime;

public class Issue
implements AddressableEntity,
ExpandableResource {
    private final BasicStatus status;
    private final URI self;
    private BasicIssueType issueType;
    private BasicProject project;
    private final URI transitionsUri;
    private final Iterable<String> expandos;
    private final Collection<BasicComponent> components;
    private final String summary;
    private BasicUser reporter;
    private BasicUser assignee;
    private String key;
    @Nullable
    private final BasicResolution resolution;
    private Collection<Field> fields;
    private DateTime creationDate;
    private DateTime updateDate;
    private final BasicPriority priority;
    private final BasicVotes votes;
    @Nullable
    private final Collection<Version> fixVersions;
    @Nullable
    private final Collection<Version> affectedVersions;
    private final Collection<Comment> comments;
    @Nullable
    private final Collection<IssueLink> issueLinks;
    private final Collection<Attachment> attachments;
    private final Collection<Worklog> worklogs;
    private final BasicWatchers watchers;

    public Issue(String summary, URI self, String key, BasicProject project, BasicIssueType issueType, BasicStatus status, @Nullable BasicPriority priority, @Nullable BasicResolution resolution, Collection<Attachment> attachments, @Nullable BasicUser reporter, @Nullable BasicUser assignee, DateTime creationDate, DateTime updateDate, Collection<Version> affectedVersions, Collection<Version> fixVersions, Collection<BasicComponent> components, Collection<Field> fields, Collection<Comment> comments, URI transitionsUri, Collection<IssueLink> issueLinks, BasicVotes votes, Collection<Worklog> worklogs, BasicWatchers watchers, Iterable<String> expandos) {
        this.summary = summary;
        this.self = self;
        this.key = key;
        this.project = project;
        this.status = status;
        this.resolution = resolution;
        this.expandos = expandos;
        this.comments = comments;
        this.attachments = attachments;
        this.fields = fields;
        this.issueType = issueType;
        this.reporter = reporter;
        this.assignee = assignee;
        this.creationDate = creationDate;
        this.updateDate = updateDate;
        this.transitionsUri = transitionsUri;
        this.issueLinks = issueLinks;
        this.votes = votes;
        this.worklogs = worklogs;
        this.watchers = watchers;
        this.fixVersions = fixVersions;
        this.affectedVersions = affectedVersions;
        this.components = components;
        this.priority = priority;
    }

    public BasicStatus getStatus() {
        return this.status;
    }

    public BasicUser getReporter() {
        return this.reporter;
    }

    @Nullable
    public BasicUser getAssignee() {
        return this.assignee;
    }

    public String getSummary() {
        return this.summary;
    }

    @Nullable
    public BasicPriority getPriority() {
        return this.priority;
    }

    public Iterable<IssueLink> getIssueLinks() {
        return this.issueLinks;
    }

    public Iterable<Field> getFields() {
        return this.fields;
    }

    @Nullable
    public Field getField(String id) {
        for (Field field : this.fields) {
            if (!field.getId().equals(id)) continue;
            return field;
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public URI getSelf() {
        return this.self;
    }

    @Override
    public Iterable<String> getExpandos() {
        return this.expandos;
    }

    public BasicIssueType getIssueType() {
        return this.issueType;
    }

    public Iterable<Attachment> getAttachments() {
        return this.attachments;
    }

    public Iterable<Comment> getComments() {
        return this.comments;
    }

    public BasicProject getProject() {
        return this.project;
    }

    public BasicVotes getVotes() {
        return this.votes;
    }

    public Iterable<Worklog> getWorklogs() {
        return this.worklogs;
    }

    public BasicWatchers getWatchers() {
        return this.watchers;
    }

    public Iterable<Version> getFixVersions() {
        return this.fixVersions;
    }

    public URI getTransitionsUri() {
        return this.transitionsUri;
    }

    public Iterable<Version> getAffectedVersions() {
        return this.affectedVersions;
    }

    public Iterable<BasicComponent> getComponents() {
        return this.components;
    }

    public URI getVotesUri() {
        return UriBuilder.fromUri((URI)this.getSelf()).path("votes").build(new Object[0]);
    }

    public BasicResolution getResolution() {
        return this.resolution;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("self", (Object)this.self).add("key", (Object)this.key).add("project", (Object)this.project).add("status", (Object)this.status).add("expandos", this.expandos).add("resolution", (Object)this.resolution).add("reporter", (Object)this.reporter).add("assignee", (Object)this.assignee).addValue((Object)"\n").add("fields", this.fields).addValue((Object)"\n").add("affectedVersions", this.affectedVersions).addValue((Object)"\n").add("fixVersions", this.fixVersions).addValue((Object)"\n").add("components", this.components).addValue((Object)"\n").add("issueType", (Object)this.issueType).add("creationDate", (Object)this.creationDate).add("updateDate", (Object)this.updateDate).addValue((Object)"\n").add("attachments", this.attachments).addValue((Object)"\n").add("comments", this.comments).addValue((Object)"\n").add("transitionsUri", (Object)this.transitionsUri).add("issueLinks", this.issueLinks).addValue((Object)"\n").add("votes", (Object)this.votes).addValue((Object)"\n").add("worklogs", this.worklogs).addValue((Object)"\n").add("watchers", (Object)this.watchers).toString();
    }
}

