AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.TransitionView",{createStatusView:function(A,B){return new JIRA.WorkflowDesigner.StatusView(_.defaults({},B,{canvas:this.canvas,model:new JIRA.WorkflowDesigner.StatusModel(A),workflowModel:new JIRA.WorkflowDesigner.WorkflowModel()})).render()},createTestData:function(A){this.sourceView=new JIRA.WorkflowDesigner.StatusView({canvas:this.canvas,model:new JIRA.WorkflowDesigner.StatusModel({x:10,y:0}),workflowModel:new JIRA.WorkflowDesigner.WorkflowModel()}).render();this.targetView=new JIRA.WorkflowDesigner.StatusView({canvas:this.canvas,model:new JIRA.WorkflowDesigner.StatusModel({x:200,y:0}),workflowModel:new JIRA.WorkflowDesigner.WorkflowModel()}).render();this.transitionModel.set({source:this.sourceView.model,target:this.targetView.model});A=_.defaults({},A,{canvas:this.canvas,canvasModel:this.canvasModel,model:this.transitionModel,sourceView:this.sourceView,targetView:this.targetView,workflowModel:this.workflowModel});this.transitionView=new JIRA.WorkflowDesigner.TransitionView(A);this.transitionView.requestResponse.setHandler("isSelected",function(){return false});this.transitionView.render()},createTransitionView:function(A,B){return new JIRA.WorkflowDesigner.TransitionView(_.defaults({},B,{canvas:this.canvas,canvasModel:new JIRA.WorkflowDesigner.CanvasModel({},{workflowModel:this.workflowModel}),model:new JIRA.WorkflowDesigner.TransitionModel(A),workflowModel:this.workflowModel})).render()},deselectTransition:function(){this.canvas.selectFigure(null);this.transitionView.requestResponse.setHandler("isSelected",function(){return false})},selectTransition:function(){this.canvas.selectFigure(this.transitionView._connection);this.transitionView.requestResponse.setHandler("isSelected",function(){return true})},setup:function(){function A(){return new draw2d.geo.Rectangle(0,0,0,0)}this.sandbox=sinon.sandbox.create();this.canvas=JIRA.WorkflowDesigner.TestUtilities.testDraw2DCanvas();this.transitionModel=new JIRA.WorkflowDesigner.TransitionModel({name:"Transition"});this.workflowModel=new JIRA.WorkflowDesigner.WorkflowModel();this.canvasModel=new JIRA.WorkflowDesigner.CanvasModel({},{workflowModel:this.workflowModel});this.canvasModel.set("showTransitionLabels",false);this.canvas.installEditPolicy(new JIRA.WorkflowDesigner.Policy.Canvas.PanningSingleSelectionPolicy(A))},teardown:function(){this.sandbox.restore()},transitionIsHighlighted:function(){return this.transitionView.isHighlighted()&&this.transitionView._connection.textIsVisible()},transitionIsSelected:function(A){return A._connection.getColor().hash()==="#1A8CFF"}});test("appearSelected()",function(){this.createTestData();this.sandbox.spy(this.transitionView._connection,"appearSelected");this.transitionView.appearSelected();equal(this.transitionView._connection.appearSelected.callCount,1,"The transition's connection appears selected")});test("destroy() displays a DeleteTransitionDialogView",function(){var B,A=this.sandbox.stub(JIRA.WorkflowDesigner.Dialogs,"DeleteTransitionDialogView").returns({show:jQuery.noop});this.createTestData();this.transitionView.destroy();equal(A.callCount,1,"A DeleteTransitionDialogView was created");B=A.args[0];equal(B.length,1,"It was passed a single argument");ok(B[0].transitionModel===this.transitionModel,"It was passed the correct TransitionModel");ok(B[0].workflowModel===this.workflowModel,"It was passed the correct WorkflowModel")});test("Reconnection triggers a reconnect event",function(){var A=sinon.spy();this.createTestData();this.transitionView.bind("reconnect",A);this.transitionView._connection.onReconnect();ok(A.called,"A reconnect event was triggered")});test("The label is not visible until the transition has a valid name",function(){this.createTestData();this.transitionModel.unset("name");sinon.stub(this.transitionView,"isSelected");ok(!this.transitionView._connection.textIsVisible(),"The transition's label isn't visible if it doesn't have a valid name");this.transitionView.isSelected.returns(true);this.transitionView.render();ok(!this.transitionView._connection.textIsVisible(),"The transition's label is not visible for selected transitions wihtout a valid name");this.transitionView.isSelected.returns(false);this.transitionView._highlight();ok(!this.transitionView._connection.textIsVisible(),"The transition's label is not visible for highlighted transitions wihtout a valid name");this.transitionView.unhighlight();this.transitionModel.set("name","Valid Name");this.selectTransition();this.transitionView.render();ok(this.transitionView._connection.textIsVisible(),"The transition's label is visible for selected transitions with a valid name");this.deselectTransition();this.transitionView._highlight();ok(this.transitionView._connection.textIsVisible(),"The transition's label is visible for highlighted transitions with a valid name");this.transitionView.unhighlight()});test("The label is hidden while connected statuses are being dragged",function(){this.createTestData();this.sourceView.trigger("highlight");ok(this.transitionIsHighlighted(),"The transition is highlighted when its source status is hovered");this.sourceView.trigger("drag");ok(!this.transitionView._connection.textIsVisible(),"The transition's label is not visible when its source status is being dragged");this.sourceView.trigger("dragEnd");ok(this.transitionView._connection.textIsVisible(),"The transition's label is visible after the source status has finished being dragged");this.targetView.trigger("highlight");ok(this.transitionIsHighlighted(),"The transition is highlighted when its target status is hovered");this.targetView.trigger("drag");ok(!this.transitionView._connection.textIsVisible(),"The transition's label is not visible when its target status is being dragged");this.targetView.trigger("dragEnd");ok(this.transitionView._connection.textIsVisible(),"The transition's label is visible after the target status has finished being dragged")});test("The label is updated after changing the transition's name",function(){this.createTestData();ok(this.transitionView._connection._label.getText().indexOf("Transition")>-1,"The label's text is correct");this.transitionModel.set("name","Updated Transition");ok(this.transitionView._connection._label.getText().indexOf("Updated Transition")>-1,"The label's text is correct after changing the transition's name")});test("The transition is highlighted on hover",function(){this.createTestData();ok(!this.transitionIsHighlighted(),"The transition is not highlighted by default");this.transitionView._connection.onMouseEnter();ok(this.transitionView.isHighlighted(),"The transition is highlighted on hover");this.transitionView._connection.onMouseLeave();ok(!this.transitionIsHighlighted(),"The transition is not highlighted after the mouse leaves")});test("The transition is highlighted when its status is hovered",function(){this.createTestData();ok(!this.transitionIsHighlighted(),"The transition is not highlighted by default");this.sourceView.trigger("highlight");ok(this.transitionIsHighlighted(),"The transition is highlighted when its source status is hovered");this.sourceView.trigger("unhighlight");ok(!this.transitionIsHighlighted(),"The transition is not highlighted when the mouse leaves its source status");this.targetView.trigger("highlight");ok(this.transitionIsHighlighted(),"The transition is highlighted when its target status is hovered");this.targetView.trigger("unhighlight");ok(!this.transitionIsHighlighted(),"The transition is not highlighted when the mouse leaves its target status")});test("The transition is highlighted when either of its statuses is selected",function(){this.createTestData();this.canvas.selectFigure(this.sourceView._getFigure());ok(this.transitionIsHighlighted(),"The transition is highlighted");this.transitionView._connection.onMouseLeave();ok(this.transitionIsHighlighted(),"The transition is still highlighted after the mouse leaves")});test("Selected transitions remain selected when the mouse leaves",function(){this.createTestData();ok(!this.transitionIsSelected(this.transitionView),"The transition does not appear selected");this.selectTransition();ok(this.transitionIsSelected(this.transitionView),"The transition appears selected after selection");this.transitionView._connection.onMouseLeave();ok(this.transitionIsSelected(this.transitionView),"The transition appears selected after mouse leaves");this.deselectTransition();ok(!this.transitionIsSelected(this.transitionView),"The transition does not appear selected after deselection")});test("The transition's sourceAngle and targetAngle attributes are automatically calculated",function(){this.createTestData();equal(this.transitionModel.get("sourceAngle"),this.sourceView.getAngleToPort(this.sourceView.getPortForAngle(0)),"The transition's sourceAngle attribute was set");equal(this.transitionModel.get("targetAngle"),this.targetView.getAngleToPort(this.targetView.getPortForAngle(180)),"The transition's targetAngle attribute was set")});test("The label is shown depending on the value of user preference 'showTransitionLabels'",function(){this.createTestData();this.canvasModel.set("showTransitionLabels",true);ok(this.transitionView._connection.textIsVisible(),"Label is visible");this.canvasModel.set("showTransitionLabels",false);ok(!this.transitionView._connection.textIsVisible(),"Label is not visible")});test("Double clicking a transition initiates editing",function(){var A=this.sandbox.stub(JIRA.WorkflowDesigner.TransitionView.prototype,"edit");this.createTestData();this.transitionView._connection.onDoubleClick();equal(A.callCount,1,"TransitionView#edit() was called after double clicking the connection");this.transitionView._connection._label.onDoubleClick();equal(A.callCount,2,"TransitionView#edit() was called after double clicking the connection's label")});test("Double clicking a transition doesn't initiate editing when immutable",function(){var B=this.sandbox.stub(JIRA.WorkflowDesigner.TransitionView.prototype,"edit"),A;this.createTestData();A=this.createTransitionView({source:this.sourceView.model,target:this.targetView.model},{immutable:true,sourceView:this.sourceView,targetView:this.targetView});A._connection.onDoubleClick();equal(B.callCount,0,"TransitionView#edit() wasn't called")});test('The connection is added to the "selected-transition" layer on selection',function(){var B=this.canvas.getLayer("selected-transition"),A=this.canvas.getLayer("transitions");this.createTestData();sinon.spy(B,"addFigure");sinon.spy(A,"addFigure");this.transitionView.select();equal(B.addFigure.callCount,1,'The "selected-transition" layer\'s #addFigure() method was called');ok(B.addFigure.args[0][0]===this.transitionView._connection,"It was passed the correct figure");this.transitionView.deselect();equal(A.addFigure.callCount,1,'The "transitions" layer\'s #addFigure() method was called');ok(A.addFigure.args[0][0]===this.transitionView._connection,"It was passed the correct figure")});test('The connection is added to the "transitions" layer',function(){var A=this.canvas.getLayer("transitions");sinon.spy(A,"addFigure");this.createTestData();equal(A.addFigure.callCount,1,'The "transitions" layer\'s #addFigure() method was called');ok(A.addFigure.args[0][0]===this.transitionView._connection,"It was passed the correct figure")});test("The connection's positionArrow method is called on selection",function(){this.createTestData();sinon.spy(this.transitionView._connection,"positionArrow");this.transitionView.select();equal(this.transitionView._connection.positionArrow.callCount,1,"The connection's positionArrow() method was called")});test("resetConnection sets the connection based on the current model",function(){var A,B;this.createTestData();A=this.transitionView.getConnection().getSource();B=this.transitionView.getConnection().getTarget();this.transitionView.getConnection().setSource(null);this.transitionView.getConnection().setTarget(null);this.transitionView.resetConnection();ok(_.isEqual(this.transitionView.getConnection().getSource(),A),"Original connection source was restored");ok(_.isEqual(this.transitionView.getConnection().getTarget(),B),"Original connection target was restored")});test("unhighlight()",function(){this.createTestData();this.sandbox.spy(this.transitionView._connection,"unhighlight");this.transitionView.unhighlight();equal(this.transitionView._connection.unhighlight.callCount,1,"The transition's connection was unhighlighted")});