(function (Backbone, Marionette) {
    Backbone.define("JIRA.WorkflowDesigner.AddTransitionFormView", Marionette.ItemView.extend(
    /** @lends JIRA.WorkflowDesigner.AddTransitionFormView# */
    {
        /**
         * Initialize the view.
         *
         * @constructs
         * @classdesc A form for creating new transitions.
         *
         * This view is abstract; do not create instances of it, use those that extend it.
         * @extends Backbone.Marionette.ItemView
         * @param {object} options
         * @param {JIRA.WorkflowDesigner.TransitionModel} options.model The new transition model.
         * @param {JIRA.WorkflowDesigner.WorkflowModel} options.workflowModel The application's workflow model.
         */
        initialize: function () {
        },

        /**
         * Clear the transition model's source and target angles.
         *
         * This is called when the source or target status changes to force
         * automatic port calculation and avoid dodgy-looking transitions.
         *
         * @private
         */
        _clearAngles: function () {
            this.model.set({
                sourceAngle: null,
                targetAngle: null
            });
        },

        /**
         * @returns {JIRA.WorkflowDesigner.StatusModel} The selected source status.
         * @private
         */
        _getSelectedSourceStatus: function () {
            var stepId = Number(this.ui.sourceStepId.find(":selected").val());
            return this.options.workflowModel.get("statuses").findWhere({
                initial: false,
                stepId: stepId
            });
        },

        /**
         * @returns {JIRA.WorkflowDesigner.StatusModel} The selected target status.
         * @private
         */
        _getSelectedTargetStatus: function () {
            var stepId = Number(this.ui.targetStepId.find(":selected").val());
            return this.options.workflowModel.get("statuses").findWhere({
                initial: false,
                stepId: stepId
            });
        },

        onShow: function () {
            var clearAngles;

            new AJS.SingleSelect({
                element: this.ui.sourceStepId,
                revertOnInvalid: true
            });

            new AJS.SingleSelect({
                element: this.ui.targetStepId,
                revertOnInvalid: true
            });

            clearAngles = _.bind(this._clearAngles, this);
            this.ui.sourceStepId.on("selected", clearAngles);
            this.ui.targetStepId.on("selected", clearAngles);
        }
    }));
}(JIRA.WorkflowDesigner.Backbone, JIRA.WorkflowDesigner.Backbone.Marionette));