AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.Dialogs.StatusDialogView", {
    setup: function () {
        var sandbox = this.sandbox = sinon.sandbox.create(),
            statusCategories;

        statusCategories = [{
            colorName: "medium-gray",
            id: 1,
            key: "undefined",
            name: "No Category"
        }, {
            colorName: "blue-gray",
            id: 2,
            key: "new",
            name: "New"
        }, {
            colorName: "green",
            id: 3,
            key: "done",
            name: "Complete"
        }];

        this.getStatusCategoriesStub = sandbox.stub(JIRA.WorkflowDesigner.IO.AJAX.StatusCategoriesAJAXManager, "getStatusCategories").returns(jQuery.Deferred().resolve(statusCategories));
        this.statusCategories = statusCategories;
        this.statusCategorySingleSelectSpy = sandbox.spy(JIRA.WorkflowDesigner, "StatusCategorySingleSelect");
    },

    /**
     * Show a `StatusDialogView`.
     *
     * @param {object} options Option to pass to the constructor.
     * @returns {jQuery} The dialog's element.
     */
    showDialog: function (options) {
        var Dialog,
            StatusDialogView = JIRA.WorkflowDesigner.Dialogs.StatusDialogView;

        Dialog = StatusDialogView.extend({
            _onError: jQuery.noop,
            _onSuccess: jQuery.noop,

            template: function (options) {
                _.extend(options, {
                    submitText: "Submit",
                    title: "Title"
                });

                return JIRA.WorkflowDesigner.Templates.statusDialog(options);
            }
        });

        options = _.defaults({}, options, {
            workflowModel: new JIRA.WorkflowDesigner.WorkflowModel(),
            statusModel: new JIRA.WorkflowDesigner.StatusModel()
        });

        new Dialog(options).show();
        return JIRA.Dialog.current && JIRA.Dialog.current.get$popup();
    },

    teardown: function () {
        JIRA.WorkflowDesigner.TestUtilities.removeDialogs();
        this.sandbox.restore();
    }
});

test("Doesn't contain a status category field if the dark feature is disabled", function () {
    equal(this.showDialog().find("#status-category-id").length, 0, "No status category field is present");
    equal(this.getStatusCategoriesStub.callCount, 0, "StatusCategoriesAJAXManager.getStatusCategories wasn't called");
    equal(this.statusCategorySingleSelectSpy.callCount, 0, "No StatusCategorySingleSelect was created");
});

test("Shows a status category field if the dark feature is enabled", function () {
    var element,
        getStatusCategoriesDeferred = jQuery.Deferred();

    this.getStatusCategoriesStub.returns(getStatusCategoriesDeferred);

    JIRA.WorkflowDesigner.TestUtilities.withDarkFeature("jira.issue.status.lozenge", true, function () {
        element = this.showDialog();
        ok(!element.is(":visible"), "The dialog isn't visible");
        equal(this.getStatusCategoriesStub.callCount, 1, "StatusCategoriesAJAXManager.getStatusCategories was called");

        getStatusCategoriesDeferred.resolve(this.statusCategories);
        equal(element.find("#status-category-id").length, 1, "The dialog contains a status category field");
        ok(element.is(":visible"), "The dialog is visible");
        equal(this.statusCategorySingleSelectSpy.callCount, 1, "A StatusCategorySingleSelect was created");
    }, this);
});

test("Shows an error message on failure to retrieve status categories", function () {
    var hideSpy = this.sandbox.spy(JIRA.WorkflowDesigner.Dialogs.StatusDialogView.prototype, "hide"),
        showErrorMessageStub = this.sandbox.stub(JIRA.WorkflowDesigner.Messages, "showErrorMessage");

    this.getStatusCategoriesStub.returns(jQuery.Deferred().reject("Nope!"));

    JIRA.WorkflowDesigner.TestUtilities.withDarkFeature("jira.issue.status.lozenge", true, function () {
        this.showDialog();

        equal(hideSpy.callCount, 1, "The dialog was hidden");
        equal(showErrorMessageStub.callCount, 1, "JIRA.WorkflowDesigner.Messages.showErrorMessage was called");
        deepEqual(showErrorMessageStub.args[0], ["Nope!"], "It was passed the correct arguments");
    }, this);
});

test("The status category field doesn't contain the undefined category", function () {
    JIRA.WorkflowDesigner.TestUtilities.withDarkFeature("jira.issue.status.lozenge", true, function () {
        equal(this.showDialog().find("#status-category-id option[value=1]").length, 0,
            "The status category field doesn't contain the undefined category");
    }, this);
});

test("The status category field is populated with the status's category", function () {
    JIRA.WorkflowDesigner.TestUtilities.withDarkFeature("jira.issue.status.lozenge", true, function () {
        var element;

        element = this.showDialog({
            statusModel: new JIRA.WorkflowDesigner.StatusModel({
                statusCategory: {
                    id: 3
                }
            })
        });

        equal(element.find("#status-category-id :selected").val(), "3",
                "The correct status category is selected");
    }, this);
});