AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:form-dialog-view");
AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");

module("JIRA.WorkflowDesigner.Dialogs.FormDialogView", {
    /**
     * @returns {JIRA.WorkflowDesigner.Dialogs.FormDialogView} A `FormDialogView`.
     */
    createDialog: function () {
        var View;

        View = JIRA.WorkflowDesigner.Dialogs.FormDialogView.extend({
            _getContent: function () {
                return jQuery("<div>").addClass("form-body");
            }
        });

        return new View();
    },

    teardown: function () {
        JIRA.WorkflowDesigner.TestUtilities.removeDialogs();
    }
});

test("showErrorMessage() does nothing if the message is empty", function () {
    var dialog;

    dialog = this.createDialog();
    dialog.show();

    _.each([null, undefined, ""], function (message) {
        dialog.showErrorMessage(message);
        equal(dialog.$(".aui-message.error").length, 0, "No error message is visible");
    });
});