(function (Backbone) {
    Backbone.define("JIRA.WorkflowDesigner.Dialogs.EditTransitionSourceDialogView", JIRA.WorkflowDesigner.Dialogs.FormDialogView.extend(
    /** @lends JIRA.WorkflowDesigner.Dialogs.EditTransitionSourceDialogView# */
    {
        id: "edit-transition-source-dialog",

        /**
         * Initialise the view.
         *
         * @constructs
         * @classdesc The workflow designer's "Edit transition source" dialog.
         * @extends JIRA.WorkflowDesigner.Dialogs.FormDialogView
         * @param {object} options
         * @param {JIRA.WorkflowDesigner.TransitionView} options.transitionView The transition view.
         * @param {JIRA.WorkflowDesigner.StatusPort} options.newSourcePort The new target port.
         * @param {JIRA.WorkflowDesigner.StatusView} options.newSourceView The new source status view.
         * @param {JIRA.WorkflowDesigner.StatusView} options.originalSourceStatus The original source status.
         * @param {JIRA.WorkflowDesigner.WorkflowModel} options.workflowModel The workflow model.
         */
        initialize: function (options) {
            _.bindAll(this, "_onError", "_onSuccess");

            this._newSourcePort = options.newSourcePort;
            this._newSourceView = options.newSourceView;
            this._originalSourceStatus = options.originalSourceStatus;
            this._transitionView = options.transitionView;
            this._workflowModel = options.workflowModel;
        },

        /**
         * @returns {jQuery} Content of the dialog.
         * @private
         */
        _getContent: function () {
            return jQuery(JIRA.WorkflowDesigner.Templates.confirmEditTransitionSourceDialog({
                newSourceStatusName: this._newSourceView.model.get("name"),
                originalSourceStatusName: this._originalSourceStatus.get("name"),
                transitionName: this._transitionView.model.get("name")
            }));
        },

        /**
         * Handler for cancel event.
         * @private
         */
        _onCancel: function () {
            this._transitionView.resetConnection();
        },

        /**
         * @param {jQuery.Event} e Submit event
         * @param {function} callback Function to call when this event has been handled
         * @private
         */
        _onSubmit: function (e, callback) {
            var request;

            e.preventDefault();
            this.disable();
            this.removeErrorMessages();

            request = JIRA.WorkflowDesigner.IO.AJAX.WorkflowTransitionsAJAXManager.updateTransitionSource({
                transitionId: this._transitionView.model.get("actionId"),
                newSourceStatusId: this._newSourceView.model.get("statusId"),
                originalSourceStatusId: this._originalSourceStatus.get("statusId"),
                workflowName: this._workflowModel.get("name")
            });

            request.done(this._onSuccess).fail(callback).fail(this._onError);
        },

        /**
         * @private
         */
        _onSuccess: function () {
            this.hide();

            this._workflowModel.updateTransitionSource({
                sourceAngle: this._newSourceView.getAngleToPort(this._newSourcePort),
                sourceStepId: this._newSourceView.model.get("stepId"),
                transition: this._transitionView.model
            });
        }
    }));
}(JIRA.WorkflowDesigner.Backbone));