(function (Backbone) {
    var StatusDialogView = JIRA.WorkflowDesigner.Dialogs.StatusDialogView;

    /**
     * @class JIRA.WorkflowDesigner.Dialogs.EditStatusDialogView
     * @classdesc The workflow designer's "Edit Status" dialog.
     * @extends JIRA.WorkflowDesigner.Dialogs.StatusDialogView
     */
    Backbone.define("JIRA.WorkflowDesigner.Dialogs.EditStatusDialogView", StatusDialogView.extend (
    /** @lends JIRA.WorkflowDesigner.Dialogs.EditStatusDialogView# */
    {
        id: "edit-status-dialog",

        template: JIRA.WorkflowDesigner.Templates.editStatusDialog,

        /**
         * This method first retrieves status information so we can display an
         * "editing this status will affect other workflows" warning if needed.
         *
         * @returns {function} A function that retrieves the dialog's content.
         * @private
         */
        _getContent: function () {
            var getContent = StatusDialogView.prototype._getContent.apply(this),
                instance = this;

            return function (callback) {
                var associatedWorkflowsRequest = JIRA.WorkflowDesigner.IO.AJAX.StatusesAJAXManager.getNumberOfAssociatedWorkflows(instance._statusModel.get("statusId")),
                    request,
                    statusesRequest = JIRA.WorkflowDesigner.IO.AJAX.StatusesAJAXManager.getStatuses();

                request = jQuery.when(associatedWorkflowsRequest, statusesRequest);
                request.done(function (numberOfWorkflows, statuses) {
                    instance._numberOfAssociatedWorkflows = numberOfWorkflows;
                    instance._statuses = statuses;
                    getContent(callback);
                });

                request.fail(function (errorMessage) {
                    JIRA.WorkflowDesigner.Messages.showErrorMessage(errorMessage);
                    instance.hide();
                });
            };
        },

        /**
         * @private
         * @returns {null|object} The selected status category or `null`.
         */
        _getSelectedStatusCategory: function () {
            var option = this.ui.statusCategoryId.find(":selected");
            return !option.length ? null : {
                colourName: option.data("color-name"),
                id: Number(option.val())
            };
        },

        /**
         * Make a request to update the status.
         *
         * @return {jQuery.Deferred} A deferred that is resolved on success.
         * @private
         */
        _makeRequest: function (options) {
            options = _.extend({}, options, {
                statusId: this._statusModel.get("statusId")
            });

            return JIRA.WorkflowDesigner.IO.AJAX.WorkflowStatusesAJAXManager.updateStatus(options);
        },

        /**
         * @private
         */
        _onSuccess: function () {
            var attributes;

            attributes = {
                description: this.ui.description.val(),
                name: this.ui.name.val(),
                statusCategory: this._getSelectedStatusCategory()
            };

            JIRA.WorkflowDesigner.Analytics.triggerUpdateStatus();
            JIRA.WorkflowDesigner.Analytics.triggerUpdateStep();
            this.hide();
            this._statusModel.set(attributes);
        },

        serializeData: function () {
            var data = StatusDialogView.prototype.serializeData.apply(this, arguments);
            return _.extend(data, {numberOfWorkflows: this._numberOfAssociatedWorkflows});
        }
    }));
}(JIRA.WorkflowDesigner.Backbone));