AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.Dialogs.EditTransitionDialogView",{setup:function(){this.sandbox=sinon.sandbox.create();this.getScreensStub=this.sandbox.stub(JIRA.WorkflowDesigner.IO.AJAX.ScreensAJAXManager,"getScreens");this.getScreensStub.returns(jQuery.Deferred().resolve([{id:1,name:"Screen"}]).promise());this.updateGlobalTransitionStub=this.sandbox.stub(JIRA.WorkflowDesigner.IO.AJAX.WorkflowGlobalTransitionsAJAXManager,"updateGlobalTransition");this.workflowModel=new JIRA.WorkflowDesigner.WorkflowModel({name:"Workflow Name"})},showDialog:function(){this.transitionModel=this.workflowModel.addTransition({actionId:"1",description:"This is a description.",name:"Transition",globalTransition:true,source:this.workflowModel.addStatus({stepId:2}),target:this.workflowModel.addStatus({stepId:2})});new JIRA.WorkflowDesigner.Dialogs.EditGlobalTransitionDialogView({transitionModel:this.transitionModel,workflowModel:this.workflowModel}).show();return JIRA.Dialog.current&&JIRA.Dialog.current.get$popup()},teardown:function(){JIRA.WorkflowDesigner.TestUtilities.removeDialogs();this.sandbox.restore()}});test("An error message is shown if editing the global transition fails",function(){var C=this.showDialog(),A,B="Oh noes!";this.updateGlobalTransitionStub.returns(jQuery.Deferred().reject(B).promise());JIRA.WorkflowDesigner.TestUtilities.submit(C);A=C.find(".aui-message.error");equal(A.length,1,"An error message is shown in the dialog");ok(A.text().indexOf(B)>-1,"It contains the correct text");equal(C.find(":input:disabled").length,0,"No elements in the dialog are disabled");this.updateGlobalTransitionStub.returns(jQuery.Deferred().promise());JIRA.WorkflowDesigner.TestUtilities.submit(C);equal(C.find(".error").length,0,"Errors are removed on submit")});test("Editing a global transition",function(){var B,A=jQuery.Deferred(),D=this.showDialog(),C;this.updateGlobalTransitionStub.returns(A.promise());this.sandbox.stub(JIRA.WorkflowDesigner.Analytics,"triggerUpdateGlobalTransition");JIRA.WorkflowDesigner.TestUtilities.submit(D,{"#transition-description":"Awesome new description!","#transition-name":"New Name","#transition-screen-id":1});equal(D.find(":input:disabled").length,D.find(":input").length,"All inputs are disabled while submitting");equal(this.updateGlobalTransitionStub.callCount,1,"GlobalTransitionsAJAXManager.updateGlobalTransition() was called");A.resolve(100);B=this.workflowModel.get("transitions").at(0).attributes;C={description:"Awesome new description!",name:"New Name",screenId:1};deepEqual(_.pick(B,_.keys(C)),C,"The global TransitionModel's attributes were updated");ok(JIRA.WorkflowDesigner.Analytics.triggerUpdateGlobalTransition.calledOnce,"Analytics event for update/globaltransition has been triggered")});test("Fields are populated with the global transition's attributes",function(){var A=this.showDialog();equal(A.find("#transition-description").val(),this.transitionModel.get("description"),"The transition's description was used");equal(A.find("#transition-name").val(),this.transitionModel.get("name"),"The transition's name was used")});