AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.Dialogs.DeleteTransitionDialogView",{setup:function(){this.sandbox=sinon.sandbox.create();this.deleteTransitionStub=this.sandbox.stub(JIRA.WorkflowDesigner.IO.AJAX.WorkflowTransitionsAJAXManager,"deleteTransition");this.deleteGlobalTransitionStub=this.sandbox.stub(JIRA.WorkflowDesigner.IO.AJAX.WorkflowGlobalTransitionsAJAXManager,"deleteGlobalTransition");this.workflowModel=new JIRA.WorkflowDesigner.WorkflowModel({name:"Workflow Name"});this.sourceStatus=this.workflowModel.addStatus({stepId:1});this.transitionModel=this.workflowModel.addTransition({actionId:1,source:this.sourceStatus,target:this.workflowModel.addStatus({stepId:2})});this.globalTransitionModel=this.workflowModel.addTransition({actionId:1,globalTransition:true,source:this.sourceStatus,target:this.workflowModel.addStatus({stepId:2})});this.transitionModel.destroy=this.sandbox.spy();this.globalTransitionModel.destroy=this.sandbox.spy()},showDialog:function(){new JIRA.WorkflowDesigner.Dialogs.DeleteTransitionDialogView({workflowModel:this.workflowModel,transitionModel:this.transitionModel}).show();return JIRA.Dialog.current&&JIRA.Dialog.current.get$popup()},showGlobalTransitionDeleteDialog:function(){new JIRA.WorkflowDesigner.Dialogs.DeleteTransitionDialogView({workflowModel:this.workflowModel,transitionModel:this.globalTransitionModel}).show();return JIRA.Dialog.current&&JIRA.Dialog.current.get$popup()},teardown:function(){JIRA.WorkflowDesigner.TestUtilities.removeDialogs();this.sandbox.restore()}});test("Deleting a transition destroys transition model",function(){var A=jQuery.Deferred(),B=this.showDialog();ok(JIRA.WorkflowDesigner.TestUtilities.dialogIsVisible(),"The dialog is visible");ok(B.find(":submit").length,"The dialog has a submit button");this.deleteTransitionStub.returns(A.promise());this.sandbox.stub(JIRA.WorkflowDesigner.Analytics,"triggerRemoveTransition");JIRA.WorkflowDesigner.TestUtilities.submit(B);equal(B.find(":input:disabled").length,B.find(":input").length,"All inputs are disabled while submitting");equal(this.deleteTransitionStub.callCount,1,"WorkflowTransitionsAJAXManager.deleteTransition() was called");A.resolve();equal(this.transitionModel.destroy.callCount,1,"Transition model destroyed");ok(!JIRA.WorkflowDesigner.TestUtilities.dialogIsVisible(),"The dialog closed");ok(JIRA.WorkflowDesigner.Analytics.triggerRemoveTransition.calledOnce,"Analytics event for remove/transition has been triggered")});test("Deleting a global transition destroys transition model",function(){var B=jQuery.Deferred(),C=this.showGlobalTransitionDeleteDialog();ok(JIRA.WorkflowDesigner.TestUtilities.dialogIsVisible(),"The dialog is visible");ok(C.find(":submit").length,"The dialog has a submit button");this.deleteGlobalTransitionStub.returns(B.promise());this.sandbox.stub(JIRA.WorkflowDesigner.Analytics,"triggerRemoveGlobalTransition");JIRA.WorkflowDesigner.TestUtilities.submit(C);var A={transitionId:1,sourceStepId:1,workflowName:"Workflow Name"};equal(C.find(":input:disabled").length,C.find(":input").length,"All inputs are disabled while submitting");equal(this.deleteGlobalTransitionStub.callCount,1,"WorkflowGlobalTransitionsAJAXManager.deleteGlobalTransition() was called");deepEqual(this.deleteGlobalTransitionStub.args[0],[A],"It was passed the correct options");B.resolve();equal(this.globalTransitionModel.destroy.callCount,1,"Transition model destroyed");ok(!JIRA.WorkflowDesigner.TestUtilities.dialogIsVisible(),"The dialog closed");ok(JIRA.WorkflowDesigner.Analytics.triggerRemoveGlobalTransition.calledOnce,"Analytics event for remove/globaltransition has been triggered")});test("An error message is shown if deleting the transition fails",function(){var C=this.showDialog(),A,B="Oh noes!";this.deleteTransitionStub.returns(jQuery.Deferred().reject(B).promise());JIRA.WorkflowDesigner.TestUtilities.submit(C);A=C.find(".aui-message.error");equal(A.length,1,"An error message is shown in the dialog");ok(A.text().indexOf(B)>-1,"It contains the correct text");equal(C.find(":input:disabled").length,0,"No elements in the dialog are disabled");this.deleteTransitionStub.returns(jQuery.Deferred().promise());JIRA.WorkflowDesigner.TestUtilities.submit(C);equal(C.find(".error").length,0,"Errors are removed on submit")});test("Closing the dialog doesn't destroy transition model",function(){var A=this.showDialog();ok(JIRA.WorkflowDesigner.TestUtilities.dialogIsVisible(),"The dialog is visible");A.find(".cancel").click();equal(this.transitionModel.destroy.callCount,0,"Transition model was not destroyed");ok(!JIRA.WorkflowDesigner.TestUtilities.dialogIsVisible(),"The dialog closed")});test("Can't delete initial transition",function(){this.sourceStatus.set("initial",true);var A=this.showDialog();ok(JIRA.WorkflowDesigner.TestUtilities.dialogIsVisible(),"The dialog is visible");ok(!A.find(":submit").length,"The dialog does not have a submit button")});